# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from testit_api_client.models.autotest_result_outcome import AutotestResultOutcome
from testit_api_client.models.int64_range_selector_model import Int64RangeSelectorModel
from typing import Optional, Set
from typing_extensions import Self

class AutotestHistoricalResultSelectModel(BaseModel):
    """
    AutotestHistoricalResultSelectModel
    """ # noqa: E501
    outcomes: Optional[List[AutotestResultOutcome]] = None
    test_plan_ids: Optional[List[StrictStr]] = Field(default=None, alias="testPlanIds")
    test_run_ids: Optional[List[StrictStr]] = Field(default=None, alias="testRunIds")
    configuration_ids: Optional[List[StrictStr]] = Field(default=None, alias="configurationIds")
    launch_source: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = Field(default=None, alias="launchSource")
    user_ids: Optional[List[StrictStr]] = Field(default=None, alias="userIds")
    duration: Optional[Int64RangeSelectorModel] = None
    __properties: ClassVar[List[str]] = ["outcomes", "testPlanIds", "testRunIds", "configurationIds", "launchSource", "userIds", "duration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AutotestHistoricalResultSelectModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of duration
        if self.duration:
            _dict['duration'] = self.duration.to_dict()
        # set to None if outcomes (nullable) is None
        # and model_fields_set contains the field
        if self.outcomes is None and "outcomes" in self.model_fields_set:
            _dict['outcomes'] = None

        # set to None if test_plan_ids (nullable) is None
        # and model_fields_set contains the field
        if self.test_plan_ids is None and "test_plan_ids" in self.model_fields_set:
            _dict['testPlanIds'] = None

        # set to None if test_run_ids (nullable) is None
        # and model_fields_set contains the field
        if self.test_run_ids is None and "test_run_ids" in self.model_fields_set:
            _dict['testRunIds'] = None

        # set to None if configuration_ids (nullable) is None
        # and model_fields_set contains the field
        if self.configuration_ids is None and "configuration_ids" in self.model_fields_set:
            _dict['configurationIds'] = None

        # set to None if launch_source (nullable) is None
        # and model_fields_set contains the field
        if self.launch_source is None and "launch_source" in self.model_fields_set:
            _dict['launchSource'] = None

        # set to None if user_ids (nullable) is None
        # and model_fields_set contains the field
        if self.user_ids is None and "user_ids" in self.model_fields_set:
            _dict['userIds'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AutotestHistoricalResultSelectModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "outcomes": obj.get("outcomes"),
            "testPlanIds": obj.get("testPlanIds"),
            "testRunIds": obj.get("testRunIds"),
            "configurationIds": obj.get("configurationIds"),
            "launchSource": obj.get("launchSource"),
            "userIds": obj.get("userIds"),
            "duration": Int64RangeSelectorModel.from_dict(obj["duration"]) if obj.get("duration") is not None else None
        })
        return _obj


