# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from testit_api_client.models.attachment_put_model import AttachmentPutModel
from testit_api_client.models.attachment_put_model_auto_test_step_results_model import AttachmentPutModelAutoTestStepResultsModel
from testit_api_client.models.available_test_result_outcome import AvailableTestResultOutcome
from testit_api_client.models.failure_category_model import FailureCategoryModel
from testit_api_client.models.link_post_model import LinkPostModel
from typing import Optional, Set
from typing_extensions import Self

class AutoTestResultsForTestRunModel(BaseModel):
    """
    AutoTestResultsForTestRunModel
    """ # noqa: E501
    configuration_id: StrictStr = Field(description="Specifies the GUID of the autotest configuration, which was specified when the test run was created.", alias="configurationId")
    links: Optional[List[LinkPostModel]] = Field(default=None, description="Specifies the links in the autotest.")
    failure_reason_names: Optional[List[FailureCategoryModel]] = Field(default=None, description="Specifies the cause of autotest failure.", alias="failureReasonNames")
    auto_test_external_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Specifies the external ID of the autotest, which was specified when the test run was created.", alias="autoTestExternalId")
    outcome: AvailableTestResultOutcome = Field(description="Specifies the result of the autotest execution.")
    message: Optional[StrictStr] = Field(default=None, description="A comment for the result.")
    traces: Optional[StrictStr] = Field(default=None, description="An extended comment or a stack trace.")
    started_on: Optional[datetime] = Field(default=None, description="Test run start date.", alias="startedOn")
    completed_on: Optional[datetime] = Field(default=None, description="Test run end date.", alias="completedOn")
    duration: Optional[Annotated[int, Field(le=43200000000, strict=True, ge=0)]] = Field(default=None, description="Expected or actual duration of the test run execution in milliseconds.")
    attachments: Optional[List[AttachmentPutModel]] = Field(default=None, description="Specifies an attachment GUID. Multiple values can be sent.")
    parameters: Optional[Dict[str, StrictStr]] = Field(default=None, description="\"<b>parameter</b>\": \"<b>value</b>\" pair with arbitrary custom parameters. Multiple parameters can be sent.")
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="\"<b>property</b>\": \"<b>value</b>\" pair with arbitrary custom properties. Multiple properties can be sent.")
    step_results: Optional[List[AttachmentPutModelAutoTestStepResultsModel]] = Field(default=None, description="Specifies the results of individual steps.", alias="stepResults")
    setup_results: Optional[List[AttachmentPutModelAutoTestStepResultsModel]] = Field(default=None, description="Specifies the results of setup steps. For information on supported values, see the `stepResults` parameter above.", alias="setupResults")
    teardown_results: Optional[List[AttachmentPutModelAutoTestStepResultsModel]] = Field(default=None, description="Specifies the results of the teardown steps. For information on supported values, see the `stepResults` parameter above.", alias="teardownResults")
    __properties: ClassVar[List[str]] = ["configurationId", "links", "failureReasonNames", "autoTestExternalId", "outcome", "message", "traces", "startedOn", "completedOn", "duration", "attachments", "parameters", "properties", "stepResults", "setupResults", "teardownResults"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AutoTestResultsForTestRunModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in step_results (list)
        _items = []
        if self.step_results:
            for _item_step_results in self.step_results:
                if _item_step_results:
                    _items.append(_item_step_results.to_dict())
            _dict['stepResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup_results (list)
        _items = []
        if self.setup_results:
            for _item_setup_results in self.setup_results:
                if _item_setup_results:
                    _items.append(_item_setup_results.to_dict())
            _dict['setupResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown_results (list)
        _items = []
        if self.teardown_results:
            for _item_teardown_results in self.teardown_results:
                if _item_teardown_results:
                    _items.append(_item_teardown_results.to_dict())
            _dict['teardownResults'] = _items
        # set to None if links (nullable) is None
        # and model_fields_set contains the field
        if self.links is None and "links" in self.model_fields_set:
            _dict['links'] = None

        # set to None if failure_reason_names (nullable) is None
        # and model_fields_set contains the field
        if self.failure_reason_names is None and "failure_reason_names" in self.model_fields_set:
            _dict['failureReasonNames'] = None

        # set to None if message (nullable) is None
        # and model_fields_set contains the field
        if self.message is None and "message" in self.model_fields_set:
            _dict['message'] = None

        # set to None if traces (nullable) is None
        # and model_fields_set contains the field
        if self.traces is None and "traces" in self.model_fields_set:
            _dict['traces'] = None

        # set to None if started_on (nullable) is None
        # and model_fields_set contains the field
        if self.started_on is None and "started_on" in self.model_fields_set:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and model_fields_set contains the field
        if self.completed_on is None and "completed_on" in self.model_fields_set:
            _dict['completedOn'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        # set to None if attachments (nullable) is None
        # and model_fields_set contains the field
        if self.attachments is None and "attachments" in self.model_fields_set:
            _dict['attachments'] = None

        # set to None if parameters (nullable) is None
        # and model_fields_set contains the field
        if self.parameters is None and "parameters" in self.model_fields_set:
            _dict['parameters'] = None

        # set to None if properties (nullable) is None
        # and model_fields_set contains the field
        if self.properties is None and "properties" in self.model_fields_set:
            _dict['properties'] = None

        # set to None if step_results (nullable) is None
        # and model_fields_set contains the field
        if self.step_results is None and "step_results" in self.model_fields_set:
            _dict['stepResults'] = None

        # set to None if setup_results (nullable) is None
        # and model_fields_set contains the field
        if self.setup_results is None and "setup_results" in self.model_fields_set:
            _dict['setupResults'] = None

        # set to None if teardown_results (nullable) is None
        # and model_fields_set contains the field
        if self.teardown_results is None and "teardown_results" in self.model_fields_set:
            _dict['teardownResults'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AutoTestResultsForTestRunModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "configurationId": obj.get("configurationId"),
            "links": [LinkPostModel.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "failureReasonNames": obj.get("failureReasonNames"),
            "autoTestExternalId": obj.get("autoTestExternalId"),
            "outcome": obj.get("outcome"),
            "message": obj.get("message"),
            "traces": obj.get("traces"),
            "startedOn": obj.get("startedOn"),
            "completedOn": obj.get("completedOn"),
            "duration": obj.get("duration"),
            "attachments": [AttachmentPutModel.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "parameters": obj.get("parameters"),
            "properties": obj.get("properties"),
            "stepResults": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj["stepResults"]] if obj.get("stepResults") is not None else None,
            "setupResults": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj["setupResults"]] if obj.get("setupResults") is not None else None,
            "teardownResults": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj["teardownResults"]] if obj.get("teardownResults") is not None else None
        })
        return _obj


