# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from testit_api_client.models.auto_test_step_model import AutoTestStepModel
from testit_api_client.models.configuration_short_model import ConfigurationShortModel
from testit_api_client.models.label_short_model import LabelShortModel
from testit_api_client.models.link_put_model import LinkPutModel
from typing import Optional, Set
from typing_extensions import Self

class AutoTestModel(BaseModel):
    """
    AutoTestModel
    """ # noqa: E501
    global_id: StrictInt = Field(description="Global ID of the autotest", alias="globalId")
    is_deleted: StrictBool = Field(description="Indicates if the autotest is deleted", alias="isDeleted")
    must_be_approved: StrictBool = Field(description="Indicates if the autotest has unapproved changes from linked work items", alias="mustBeApproved")
    id: StrictStr = Field(description="Unique ID of the autotest")
    created_date: datetime = Field(description="Creation date of the autotest", alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, description="Last modification date of the project", alias="modifiedDate")
    created_by_id: StrictStr = Field(description="Unique ID of the project creator", alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, description="Unique ID of the project last editor", alias="modifiedById")
    last_test_run_id: Optional[StrictStr] = Field(default=None, description="Unique ID of the autotest last test run", alias="lastTestRunId")
    last_test_run_name: Optional[StrictStr] = Field(default=None, description="Name of the autotest last test run", alias="lastTestRunName")
    last_test_result_id: Optional[StrictStr] = Field(default=None, description="Unique ID of the autotest last test result", alias="lastTestResultId")
    last_test_result_configuration: Optional[ConfigurationShortModel] = Field(default=None, description="Configuration of the autotest last test result", alias="lastTestResultConfiguration")
    last_test_result_outcome: Optional[StrictStr] = Field(default=None, description="Outcome of the autotest last test result", alias="lastTestResultOutcome")
    stability_percentage: Optional[StrictInt] = Field(default=None, description="Stability percentage of the autotest", alias="stabilityPercentage")
    external_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="External ID of the autotest", alias="externalId")
    links: Optional[List[LinkPutModel]] = Field(default=None, description="Collection of the autotest links")
    project_id: StrictStr = Field(description="Unique ID of the autotest project", alias="projectId")
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Name of the autotest")
    namespace: Optional[StrictStr] = Field(default=None, description="Name of the autotest namespace")
    classname: Optional[StrictStr] = Field(default=None, description="Name of the autotest class")
    steps: Optional[List[AutoTestStepModel]] = Field(default=None, description="Collection of the autotest steps")
    setup: Optional[List[AutoTestStepModel]] = Field(default=None, description="Collection of the autotest setup steps")
    teardown: Optional[List[AutoTestStepModel]] = Field(default=None, description="Collection of the autotest teardown steps")
    title: Optional[StrictStr] = Field(default=None, description="Name of the autotest in autotest's card")
    description: Optional[StrictStr] = Field(default=None, description="Description of the autotest in autotest's card")
    labels: Optional[List[LabelShortModel]] = Field(default=None, description="Collection of the autotest labels")
    is_flaky: Optional[StrictBool] = Field(default=None, description="Indicates if the autotest is marked as flaky", alias="isFlaky")
    external_key: Optional[StrictStr] = Field(default=None, description="External key of the autotest", alias="externalKey")
    __properties: ClassVar[List[str]] = ["globalId", "isDeleted", "mustBeApproved", "id", "createdDate", "modifiedDate", "createdById", "modifiedById", "lastTestRunId", "lastTestRunName", "lastTestResultId", "lastTestResultConfiguration", "lastTestResultOutcome", "stabilityPercentage", "externalId", "links", "projectId", "name", "namespace", "classname", "steps", "setup", "teardown", "title", "description", "labels", "isFlaky", "externalKey"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AutoTestModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_test_result_configuration
        if self.last_test_result_configuration:
            _dict['lastTestResultConfiguration'] = self.last_test_result_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item_steps in self.steps:
                if _item_steps:
                    _items.append(_item_steps.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup (list)
        _items = []
        if self.setup:
            for _item_setup in self.setup:
                if _item_setup:
                    _items.append(_item_setup.to_dict())
            _dict['setup'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown (list)
        _items = []
        if self.teardown:
            for _item_teardown in self.teardown:
                if _item_teardown:
                    _items.append(_item_teardown.to_dict())
            _dict['teardown'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        # set to None if last_test_run_id (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_run_id is None and "last_test_run_id" in self.model_fields_set:
            _dict['lastTestRunId'] = None

        # set to None if last_test_run_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_run_name is None and "last_test_run_name" in self.model_fields_set:
            _dict['lastTestRunName'] = None

        # set to None if last_test_result_id (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result_id is None and "last_test_result_id" in self.model_fields_set:
            _dict['lastTestResultId'] = None

        # set to None if last_test_result_configuration (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result_configuration is None and "last_test_result_configuration" in self.model_fields_set:
            _dict['lastTestResultConfiguration'] = None

        # set to None if last_test_result_outcome (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result_outcome is None and "last_test_result_outcome" in self.model_fields_set:
            _dict['lastTestResultOutcome'] = None

        # set to None if stability_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.stability_percentage is None and "stability_percentage" in self.model_fields_set:
            _dict['stabilityPercentage'] = None

        # set to None if links (nullable) is None
        # and model_fields_set contains the field
        if self.links is None and "links" in self.model_fields_set:
            _dict['links'] = None

        # set to None if namespace (nullable) is None
        # and model_fields_set contains the field
        if self.namespace is None and "namespace" in self.model_fields_set:
            _dict['namespace'] = None

        # set to None if classname (nullable) is None
        # and model_fields_set contains the field
        if self.classname is None and "classname" in self.model_fields_set:
            _dict['classname'] = None

        # set to None if steps (nullable) is None
        # and model_fields_set contains the field
        if self.steps is None and "steps" in self.model_fields_set:
            _dict['steps'] = None

        # set to None if setup (nullable) is None
        # and model_fields_set contains the field
        if self.setup is None and "setup" in self.model_fields_set:
            _dict['setup'] = None

        # set to None if teardown (nullable) is None
        # and model_fields_set contains the field
        if self.teardown is None and "teardown" in self.model_fields_set:
            _dict['teardown'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if is_flaky (nullable) is None
        # and model_fields_set contains the field
        if self.is_flaky is None and "is_flaky" in self.model_fields_set:
            _dict['isFlaky'] = None

        # set to None if external_key (nullable) is None
        # and model_fields_set contains the field
        if self.external_key is None and "external_key" in self.model_fields_set:
            _dict['externalKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AutoTestModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "globalId": obj.get("globalId"),
            "isDeleted": obj.get("isDeleted"),
            "mustBeApproved": obj.get("mustBeApproved"),
            "id": obj.get("id"),
            "createdDate": obj.get("createdDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "createdById": obj.get("createdById"),
            "modifiedById": obj.get("modifiedById"),
            "lastTestRunId": obj.get("lastTestRunId"),
            "lastTestRunName": obj.get("lastTestRunName"),
            "lastTestResultId": obj.get("lastTestResultId"),
            "lastTestResultConfiguration": ConfigurationShortModel.from_dict(obj["lastTestResultConfiguration"]) if obj.get("lastTestResultConfiguration") is not None else None,
            "lastTestResultOutcome": obj.get("lastTestResultOutcome"),
            "stabilityPercentage": obj.get("stabilityPercentage"),
            "externalId": obj.get("externalId"),
            "links": [LinkPutModel.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "projectId": obj.get("projectId"),
            "name": obj.get("name"),
            "namespace": obj.get("namespace"),
            "classname": obj.get("classname"),
            "steps": [AutoTestStepModel.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None,
            "setup": [AutoTestStepModel.from_dict(_item) for _item in obj["setup"]] if obj.get("setup") is not None else None,
            "teardown": [AutoTestStepModel.from_dict(_item) for _item in obj["teardown"]] if obj.get("teardown") is not None else None,
            "title": obj.get("title"),
            "description": obj.get("description"),
            "labels": [LabelShortModel.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "isFlaky": obj.get("isFlaky"),
            "externalKey": obj.get("externalKey")
        })
        return _obj


