# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.autotest_result_outcome import AutotestResultOutcome
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.int64_range_selector_model import Int64RangeSelectorModel
from typing import Optional, Set
from typing_extensions import Self

class AutoTestFilterModel(BaseModel):
    """
    AutoTestFilterModel
    """ # noqa: E501
    project_ids: Optional[List[StrictStr]] = Field(default=None, alias="projectIds")
    external_ids: Optional[List[StrictStr]] = Field(default=None, alias="externalIds")
    global_ids: Optional[List[StrictInt]] = Field(default=None, alias="globalIds")
    name: Optional[StrictStr] = None
    is_flaky: Optional[StrictBool] = Field(default=None, alias="isFlaky")
    must_be_approved: Optional[StrictBool] = Field(default=None, alias="mustBeApproved")
    stability_percentage: Optional[Int64RangeSelectorModel] = Field(default=None, alias="stabilityPercentage")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate")
    created_by_ids: Optional[List[StrictStr]] = Field(default=None, alias="createdByIds")
    modified_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="modifiedDate")
    modified_by_ids: Optional[List[StrictStr]] = Field(default=None, alias="modifiedByIds")
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted")
    namespace: Optional[StrictStr] = None
    is_empty_namespace: Optional[StrictBool] = Field(default=None, alias="isEmptyNamespace")
    class_name: Optional[StrictStr] = Field(default=None, alias="className")
    is_empty_class_name: Optional[StrictBool] = Field(default=None, alias="isEmptyClassName")
    last_test_result_outcome: Optional[AutotestResultOutcome] = Field(default=None, alias="lastTestResultOutcome")
    last_test_result_status_code: Optional[StrictStr] = Field(default=None, alias="lastTestResultStatusCode")
    external_key: Optional[StrictStr] = Field(default=None, alias="externalKey")
    last_test_result_configuration_ids: Optional[List[StrictStr]] = Field(default=None, alias="lastTestResultConfigurationIds")
    __properties: ClassVar[List[str]] = ["projectIds", "externalIds", "globalIds", "name", "isFlaky", "mustBeApproved", "stabilityPercentage", "createdDate", "createdByIds", "modifiedDate", "modifiedByIds", "isDeleted", "namespace", "isEmptyNamespace", "className", "isEmptyClassName", "lastTestResultOutcome", "lastTestResultStatusCode", "externalKey", "lastTestResultConfigurationIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AutoTestFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of stability_percentage
        if self.stability_percentage:
            _dict['stabilityPercentage'] = self.stability_percentage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of modified_date
        if self.modified_date:
            _dict['modifiedDate'] = self.modified_date.to_dict()
        # set to None if project_ids (nullable) is None
        # and model_fields_set contains the field
        if self.project_ids is None and "project_ids" in self.model_fields_set:
            _dict['projectIds'] = None

        # set to None if external_ids (nullable) is None
        # and model_fields_set contains the field
        if self.external_ids is None and "external_ids" in self.model_fields_set:
            _dict['externalIds'] = None

        # set to None if global_ids (nullable) is None
        # and model_fields_set contains the field
        if self.global_ids is None and "global_ids" in self.model_fields_set:
            _dict['globalIds'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if is_flaky (nullable) is None
        # and model_fields_set contains the field
        if self.is_flaky is None and "is_flaky" in self.model_fields_set:
            _dict['isFlaky'] = None

        # set to None if must_be_approved (nullable) is None
        # and model_fields_set contains the field
        if self.must_be_approved is None and "must_be_approved" in self.model_fields_set:
            _dict['mustBeApproved'] = None

        # set to None if stability_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.stability_percentage is None and "stability_percentage" in self.model_fields_set:
            _dict['stabilityPercentage'] = None

        # set to None if created_date (nullable) is None
        # and model_fields_set contains the field
        if self.created_date is None and "created_date" in self.model_fields_set:
            _dict['createdDate'] = None

        # set to None if created_by_ids (nullable) is None
        # and model_fields_set contains the field
        if self.created_by_ids is None and "created_by_ids" in self.model_fields_set:
            _dict['createdByIds'] = None

        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_ids (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_ids is None and "modified_by_ids" in self.model_fields_set:
            _dict['modifiedByIds'] = None

        # set to None if is_deleted (nullable) is None
        # and model_fields_set contains the field
        if self.is_deleted is None and "is_deleted" in self.model_fields_set:
            _dict['isDeleted'] = None

        # set to None if namespace (nullable) is None
        # and model_fields_set contains the field
        if self.namespace is None and "namespace" in self.model_fields_set:
            _dict['namespace'] = None

        # set to None if is_empty_namespace (nullable) is None
        # and model_fields_set contains the field
        if self.is_empty_namespace is None and "is_empty_namespace" in self.model_fields_set:
            _dict['isEmptyNamespace'] = None

        # set to None if class_name (nullable) is None
        # and model_fields_set contains the field
        if self.class_name is None and "class_name" in self.model_fields_set:
            _dict['className'] = None

        # set to None if is_empty_class_name (nullable) is None
        # and model_fields_set contains the field
        if self.is_empty_class_name is None and "is_empty_class_name" in self.model_fields_set:
            _dict['isEmptyClassName'] = None

        # set to None if last_test_result_outcome (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result_outcome is None and "last_test_result_outcome" in self.model_fields_set:
            _dict['lastTestResultOutcome'] = None

        # set to None if last_test_result_status_code (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result_status_code is None and "last_test_result_status_code" in self.model_fields_set:
            _dict['lastTestResultStatusCode'] = None

        # set to None if external_key (nullable) is None
        # and model_fields_set contains the field
        if self.external_key is None and "external_key" in self.model_fields_set:
            _dict['externalKey'] = None

        # set to None if last_test_result_configuration_ids (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result_configuration_ids is None and "last_test_result_configuration_ids" in self.model_fields_set:
            _dict['lastTestResultConfigurationIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AutoTestFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "projectIds": obj.get("projectIds"),
            "externalIds": obj.get("externalIds"),
            "globalIds": obj.get("globalIds"),
            "name": obj.get("name"),
            "isFlaky": obj.get("isFlaky"),
            "mustBeApproved": obj.get("mustBeApproved"),
            "stabilityPercentage": Int64RangeSelectorModel.from_dict(obj["stabilityPercentage"]) if obj.get("stabilityPercentage") is not None else None,
            "createdDate": DateTimeRangeSelectorModel.from_dict(obj["createdDate"]) if obj.get("createdDate") is not None else None,
            "createdByIds": obj.get("createdByIds"),
            "modifiedDate": DateTimeRangeSelectorModel.from_dict(obj["modifiedDate"]) if obj.get("modifiedDate") is not None else None,
            "modifiedByIds": obj.get("modifiedByIds"),
            "isDeleted": obj.get("isDeleted"),
            "namespace": obj.get("namespace"),
            "isEmptyNamespace": obj.get("isEmptyNamespace"),
            "className": obj.get("className"),
            "isEmptyClassName": obj.get("isEmptyClassName"),
            "lastTestResultOutcome": obj.get("lastTestResultOutcome"),
            "lastTestResultStatusCode": obj.get("lastTestResultStatusCode"),
            "externalKey": obj.get("externalKey"),
            "lastTestResultConfigurationIds": obj.get("lastTestResultConfigurationIds")
        })
        return _obj


