# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AttachmentApiResult(BaseModel):
    """
    AttachmentApiResult
    """ # noqa: E501
    id: StrictStr = Field(description="Unique ID of the attachment")
    file_id: StrictStr = Field(description="Unique ID of the attachment file", alias="fileId")
    type: StrictStr = Field(description="MIME type of the attachment")
    size: Union[StrictFloat, StrictInt] = Field(description="Size in bytes of the attachment file")
    created_date: datetime = Field(description="Creation date of the attachment", alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, description="Last modification date of the attachment", alias="modifiedDate")
    created_by_id: StrictStr = Field(description="Unique ID of the attachment creator", alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, description="Unique ID of the attachment last editor", alias="modifiedById")
    name: StrictStr = Field(description="Name of the attachment file")
    __properties: ClassVar[List[str]] = ["id", "fileId", "type", "size", "createdDate", "modifiedDate", "createdById", "modifiedById", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AttachmentApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AttachmentApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "fileId": obj.get("fileId"),
            "type": obj.get("type"),
            "size": obj.get("size"),
            "createdDate": obj.get("createdDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "createdById": obj.get("createdById"),
            "modifiedById": obj.get("modifiedById"),
            "name": obj.get("name")
        })
        return _obj


