# Open Autonomy CLI tool

`open-autonomy` is a collection of tools from the {{open_autonomy}} framework packaged into a CLI tool.

## Deploy

```
Usage: autonomy deploy [OPTIONS] COMMAND [ARGS]...

  Deploy an agent service.

Options:
  --help  Show this message and exit.

Commands:
  build       Build deployment setup for n agents.
  from-token  Run service deployment.
  run         Run deployment.
```

### Build tools

1. Service deployment

    ```
    Usage: autonomy deploy build [OPTIONS] [KEYS_FILE]

      Build deployment setup for n agents.

    Options:
      --o PATH                        Path to output dir.
      --n INTEGER                     Number of agents.
      --docker                        Use docker as a backend.
      --kubernetes                    Use kubernetes as a backend.
      --dev                           Create development environment.
      --force                         Remove existing build and overwrite with new
                                      one.
      --log-level [INFO|DEBUG|WARNING|ERROR|CRITICAL]
                                      Logging level for runtime.
      --packages-dir PATH             Path to packages dir (Use with dev mode)
      --open-aea-dir PATH             Path to open-aea repo (Use with dev mode)
      --open-autonomy-dir PATH        Path to open-autonomy repo (Use with dev
                                      mode)
      --aev                           Apply environment variable when loading
                                      service config.
      --use-hardhat                   Include a hardhat node in the deployment
                                      setup.
      --use-acn                       Include an ACN node in the deployment setup.
      --image-version TEXT            Define runtime image version.
      --remote                        To use a remote registry.
      --local                         To use a local registry.
      -p                              Ask for password interactively
      --password PASSWORD             Set password for key encryption/decryption
      --help                          Show this message and exit.
    ```

    To execute this command you need to be located within a service folder. That is, a folder containing the service configuration file (`service.yaml`) and a file containing keys with funds for the chain you want to use. The deployment will be created in the subfolder `./abci_build`.

2. Agent service images

    ```
    Usage: autonomy build-image [OPTIONS] [PUBLIC_ID_OR_HASH]

      Build runtime images for autonomous agents.

    Options:
      --service-dir PATH  Path to service dir.
      --version TEXT      Specify tag version for the image.
      --dev               Build development image.
      --pull              Pull latest dependencies.
      --help              Show this message and exit.
    ```

    ```
    # To build an image, navigate to the service dir and run
    $ autonomy build-image
    ```

    To execute this command you need to be located within a service directory. That is, a directory containing the service configuration file (`service.yaml`) and a file containing keys with funds for the chain you want to use. Images generated by this command will follow `valory/oar-<PUBLIC_ID>` format for labels.

    If you just want to build image for a specific agent without fetching a service run

    ```
    $ autonomy build-image PUBLIC_ID
    ```

3. Run deployments

    ```
    Usage: autonomy deploy run [OPTIONS]

      Run deployment.

    Options:
      --build-dir PATH
      --no-recreate     If containers already exist, dont recreate them.
      --remove-orphans  Remove containers for services not defined in the Compose
                        file.
      --help            Show this message and exit.
    ```

    This command is a wrapper around `docker-compose up` to run the service deployment.  To execute this command you need to be located within the deployment environment subfolder (`./abci_build`).

4. One click deployments

    If you have a service registered on-chain you can deploy the services directly using token IDs generated after the minting the service component. See the [register a service on-chain](./guides/register_packages_on_chain.md#register-a-service) guide for more information.

    ```
    Usage: autonomy deploy from-token [OPTIONS] TOKEN_ID KEYS_FILE

      Run service deployment.

    Options:
      --rpc TEXT      Custom RPC URL
      --sca TEXT      Service contract address for custom RPC URL.
      --n INTEGER     Number of agents to include in the build.
      --skip-image    Skip building images.
      --aev           Apply environment variable when loading service config.
      --use-goerli    Use goerli chain to resolve the token id.
      --use-ethereum  Use ethereum chain to resolve the token id.
      --use-staging   Use staging chain to resolve the token id.
      --help          Show this message and exit.
    ```

    To run a deployment for the on-chain service you need the token id for the minted service and funded keys. Save the keys in the `keys.json` and run

    ```
    $ autonomy deploy from-token <TOKEN_ID> keys.json
    ```

    Currently we support Autonolas staging chain, Görli testnet and Ethereum mainnet for resolving on-chain token ids, but if you have a contract deployed on some other chain you can provide the RPC URL to the chain and contract address using `--rpc` and `--sca`.


You can see an example on how to use the commands in this section to build and run a local deployment (Hello world agent service) in the [quick start guide](./guides/quick_start.md).

## Replay

Replay tools can be used to re-run the agents execution using data dumps from previous runs.

**Note: Replay only works for deployments which were ran in dev mode**

```
Usage: autonomy replay [OPTIONS] COMMAND [ARGS]...
  Replay tools.
Options:
  --help  Show this message and exit.
Commands:
  agent       Agent runner.
  tendermint  Tendermint runner.
```

### agent

```
Usage: autonomy replay agent [OPTIONS] AGENT
  Agent runner.
Options:
  --build PATH     Path to build dir.
  --registry PATH  Path to registry folder.
  --help           Show this message and exit.
```

### tendermint

```
Usage: autonomy replay tendermint [OPTIONS]
  Tendermint runner.
Options:
  --build PATH  Path to build directory.
  --help        Show this message and exit.
```


## Replay agents runs from Tendermint dumps

1. Copy and paste the following Makefile into your local environment:

```
.PHONY: run-hardhat
run-hardhat:
  docker run -p 8545:8545 -it valory/open-autonomy-hardhat:0.1.0

# if you get following error
# PermissionError: [Errno 13] Permission denied: '/open-aea/build/bdist.linux-x86_64/wheel'
# or similar to PermissionError: [Errno 13] Permission denied: /**/build
# remove build directory from the folder that you got error for
# for example here it should be /path/to/open-aea/repo/build
.PHONY: run-oracle-dev
run-oracle-dev:
  if [ "${OPEN_AEA_REPO_DIR}" = "" ];\
  then\
    echo "Please ensure you have set the environment variable 'OPEN_AEA_REPO_DIR'"
    exit 1
  fi
  if [ "$(shell ls ${OPEN_AEA_REPO_DIR}/build)" != "" ];\
  then \
    echo "Please remove ${OPEN_AEA_REPO_DIR}/build manually."
    exit 1
  fi

  autonomy build-image valory/oracle_hardhat --dev && \
    autonomy deploy build valory/oracle_hardhat deployments/keys/hardhat_keys.json --force --dev && \
    make run-deploy

.PHONY: run-deploy
run-deploy:
  if [ "${PLATFORM_STR}" = "Linux" ];\
  then\
    mkdir -p abci_build/persistent_data/logs
    mkdir -p abci_build/persistent_data/venvs
    sudo chown -R 1000:1000 -R abci_build/persistent_data/logs
    sudo chown -R 1000:1000 -R abci_build/persistent_data/venvs
  fi
  if [ "${DEPLOYMENT_TYPE}" = "docker-compose" ];\
  then\
    cd abci_build/ &&  \
    docker-compose up --force-recreate -t 600 --remove-orphans
    exit 0
  fi
  if [ "${DEPLOYMENT_TYPE}" = "kubernetes" ];\
  then\
    kubectl create ns ${VERSION}|| (echo "failed to deploy to namespace already existing!" && exit 0)
    kubectl create secret generic regcred \
          --from-file=.dockerconfigjson=/home/$(shell whoami)/.docker/config.json \
          --type=kubernetes.io/dockerconfigjson -n ${VERSION} || (echo "failed to create secret" && exit 1)
    cd abci_build/ && \
      kubectl apply -f build.yaml -n ${VERSION} && \
      kubectl apply -f agent_keys/ -n ${VERSION} && \
      exit 0
  fi
  echo "Please ensure you have set the environment variable 'DEPLOYMENT_TYPE'"
  exit 1
```
Then define the relevant environment variables.


2. Run your preferred app in dev mode, for example run oracle in dev using `make run-oracle-dev` and in a separate terminal run `make run-hardhat`.

3. Wait until at least one reset (`reset_and_pause` round) has occurred, because the Tendermint server will only dump Tendermint data on resets. Once you have a data dump stop the app.

4. Run `autonomy replay tendermint` . This will spawn a tendermint network with the available dumps.

5. Now  you can run replays for particular agents using `autonomy replay agent AGENT_ID`. `AGENT_ID` is a number between `0` and the number of available agents `-1`. E.g. `autonomy replay agent 0` will run the replay for the first agent.


## Analyse

```
Usage: autonomy analyse [OPTIONS] COMMAND [ARGS]...

  Analyse an agent service.

Options:
  --help  Show this message and exit.

Commands:
  benchmarks  Benchmark aggregator.
  docstrings  Analyse ABCI docstring definitions.
  fsm-specs   Generate ABCI app specs.
  handlers    Check handler definitions.
  logs        Parse logs of an agent service.
```

**Check ABCI app docstrings**

```
Usage: autonomy analyse docstrings [OPTIONS]

  Analyse ABCI docstring definitions.

Options:
  --update  Update docstrings if required.
  --help    Show this message and exit.
```

To analyse docstrings run the command in the directory containing the `packages/` folder

```
$ autonomy analyse docstrings
```

To update the docstrings, run the command with `--update` flag

```
$ autonomy analyse docstrings --update
```

**Analyse FSM specifications**

```
Usage: autonomy analyse fsm-specs [OPTIONS]

  Generate ABCI app specs.

Options:
  --package PATH
  --app-class TEXT
  --update          Update FSM definition if check fails.
  --mermaid         Mermaid file.
  --yaml            Yaml file.
  --json            Json file.
  --help            Show this message and exit.
```

Analyse specification for one skill package using

```
$ autonomy analyse fsm-specs --package PATH_TO_SKILL_PACKAGE
```

To create or update an FSM specification from existing abci app definition run

```
$ autonomy analyse fsm-specs --update --package PATH_TO_SKILL_PACKAGE --app-class NAME_OF_THE_ABCI_CLASS
```

To analyse all available FSM specifications in a local repository, navigate to directory containing `packages/` folder and run

```
$ autonomy analyse fsm-specs
```

**Analyse handler definitions**

```
Usage: autonomy analyse handlers [OPTIONS]

  Check handler definitions.

Options:
  -h, --common-handlers TEXT  Specify which handlers to check. Eg. -h
                              handler_a -h handler_b -h handler_c
  -i, --ignore TEXT           Specify which skills to skip. Eg. -i skill_0 -i
                              skill_1 -i skill_2
  --help                      Show this message and exit.
```

To analyse handlers in a local repository, navigate to directory containing `packages/` folder and run

```
$ autonomy analyse handlers -h COMMON_HANDLER_DEFINITION_TO_CHECK -i SKILL_TO_IGNORE
```

**Parse logs from a deployment**

```
Usage: autonomy analyse logs [OPTIONS] FILE
  Parse logs.
Options:
  --help  Show this message and exit.
```

### benchmarks

```
Usage: autonomy analyse benchmarks [OPTIONS] PATH
  Benchmark Aggregator.
Options:
  -b, --block-type [local|consensus|total|all]
  -d, --period INTEGER
  -o, --output FILE
  --help                          Show this message and exit.
```

Aggregating results from deployments.

To use this tool you'll need benchmark data generated from agent runtime. To generate benchmark data run

```
$ autonomy deploy build PATH_RO_KEYS --dev
```

By default this will create a 4 agent runtime where you can wait until all 4 agents are at the end of the first period (you can wait for more periods if you want) and then you can stop the runtime. The data will be stored in `abci_build/persistent_data/benchmarks` folder.

Run deployment using

```
$ cd abci_build/
$ docker-compose up
```

You can use this tool to aggregate this data.

```
autonomy analyse benchmarks abci_build/persistent_data/benchmarks
```

By default tool will generate output for all periods but you can specify which period to generate output for, same goes for block types as well.


## Fetch

```
Usage: autonomy fetch [OPTIONS] PUBLIC_ID_OR_HASH

  Fetch an agent from the registry.

Options:
  --remote      To use a remote registry.
  --local       To use a local registry.
  --alias TEXT  Provide a local alias for the agent.
  --agent       Provide a local alias for the agent.
  --service     Provide a local alias for the agent.
  --help        Show this message and exit.
```

#### Example


```
autonomy fetch --local --alias oracle valory/oracle:0.1.0
```

## Run

```
Usage: autonomy run [OPTIONS]

  Run the agent. Available for docker compose deployments only, not for kubernetes deployments.

Options:
  -p                          Ask for password interactively
  --password PASSWORD         Set password for key encryption/decryption
  --connections TEXT          The connection names to use for running the
                              agent. Must be declared in the agent's
                              configuration file.
  --env PATH                  Specify an environment file (default: .env)
  --install-deps              Install all the dependencies before running the
                              agent.
  --profiling INTEGER         Enable profiling, print profiling every amount
                              of seconds
  --memray                    Enable memray tracing, create a bin file with
                              the memory dump
  --exclude-connections TEXT  The connection names to disable for running the
                              agent. Must be declared in the agent's
                              configuration file.
  --aev                       Populate Agent configs from Environment
                              variables.
  --help                      Show this message and exit.
```

#### Example


```
autonomy run --aev
```

## Scaffold

The scaffold tool lets users generate boilerplate code that acts as a template to speed-up the development of packages.


```
Usage: autonomy scaffold [OPTIONS] COMMAND [ARGS]...

  Scaffold a package for the agent.

Options:
  -tlr, --to-local-registry  Scaffold skill inside a local registry.
  --with-symlinks            Add symlinks from vendor to non-vendor and
                             packages to vendor folders.
  --help                     Show this message and exit.

Commands:
  connection              Add a connection scaffolding to the configuration file and agent.
  contract                Add a connection scaffolding to the configuration file and agent.
  decision-maker-handler  Add a decision maker scaffolding to the configuration file and agent.
  error-handler           Add an error scaffolding to the configuration file and agent.
  fsm                     Add an ABCI skill scaffolding from an FSM specification.
  protocol                Add a protocol scaffolding to the configuration file and agent.
  skill                   Add a skill scaffolding to the configuration file and agent.

```

#### Example


```
autonomy scaffold connection my_connection
```
