/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.disp.json;

import com.cmayes.common.MediaType;
import com.cmayes.common.exception.EnvironmentException;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import org.cmayes.hartree.disp.Display;

public class JsonDisplay
implements Display<Object> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean first = true;
    private volatile boolean writeMulti = false;

    public JsonDisplay() {
        this.objectMapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Override
    public void finish(Writer writer) {
        if (this.writeMulti) {
            try {
                writer.write("]");
            }
            catch (IOException e) {
                throw new EnvironmentException("Problems writing JSON closing value ", (Throwable)e, new Object[0]);
            }
        }
        this.first = true;
    }

    @Override
    public void write(Writer writer, Object valToDisp) {
        try {
            if (this.first) {
                writer.write("[");
                this.first = false;
            } else if (this.writeMulti) {
                writer.write(",");
            }
            this.objectMapper.writeValue(writer, valToDisp);
        }
        catch (JsonGenerationException e) {
            throw new EnvironmentException("Problems writing JSON for value " + valToDisp, (Throwable)e, new Object[0]);
        }
        catch (JsonMappingException e) {
            throw new EnvironmentException("Problems writing JSON for value " + valToDisp, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new EnvironmentException("Problems writing JSON for value " + valToDisp, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public MediaType getMediaType() {
        return MediaType.JSON;
    }

    @Override
    public boolean isWriteMulti() {
        return this.writeMulti;
    }

    @Override
    public void setWriteMulti(boolean multi) {
        this.writeMulti = multi;
    }
}

