"""
Memory Machines SDK Exceptions
"""


class MemoryMachinesError(Exception):
    """Base exception for Memory Machines SDK."""
    pass


class AuthenticationError(MemoryMachinesError):
    """Raised when API key is invalid or expired."""
    pass


class RateLimitError(MemoryMachinesError):
    """Raised when rate limit is exceeded."""
    pass


class NotFoundError(MemoryMachinesError):
    """Raised when requested resource is not found."""
    pass


class ValidationError(MemoryMachinesError):
    """Raised when request data is invalid."""
    pass


class APIError(MemoryMachinesError):
    """Raised when API returns an error."""
    pass
