"""
Memory Machines Python SDK

Official Python SDK for Memory Machines API.

Quick Start:
    # First time: save your API key
    >>> from memorymachines import login
    >>> login("mm_sk_...")

    # Then just use it (no api_key needed)
    >>> from memorymachines import MemoryClient
    >>> client = MemoryClient()
    >>> client.search("what did I discuss last week?")
"""

from .client import MemoryClient
from .auth import (
    login,
    logout,
    whoami,
    get_token,
    list_profiles,
    set_active_profile,
)
from .exceptions import (
    MemoryMachinesError,
    AuthenticationError,
    RateLimitError,
    NotFoundError,
    ValidationError,
    APIError
)

__version__ = "0.1.2"
__all__ = [
    # Client
    "MemoryClient",
    # Auth
    "login",
    "logout",
    "whoami",
    "get_token",
    "list_profiles",
    "set_active_profile",
    # Exceptions
    "MemoryMachinesError",
    "AuthenticationError",
    "RateLimitError",
    "NotFoundError",
    "ValidationError",
    "APIError",
]
