# Copyright 2016-2019 The Van Valen Lab at the California Institute of
# Technology (Caltech), with support from the Paul Allen Family Foundation,
# Google, & National Institutes of Health (NIH) under Grant U24CA224309-01.
# All rights reserved.
#
# Licensed under a modified Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.github.com/vanvalenlab/deepcell-toolbox/LICENSE
#
# The Work provided may be used for non-commercial academic purposes only.
# For any other use of the Work, including commercial use, please contact:
# vanvalenlab@gmail.com
#
# Neither the name of Caltech nor the names of its contributors may be used
# to endorse or promote products derived from this software without specific
# prior written permission.
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from deepcell_toolbox import processing
from deepcell_toolbox import retinanet

from deepcell_toolbox.processing import normalize
from deepcell_toolbox.processing import phase_preprocess
from deepcell_toolbox.processing import histogram_normalization
from deepcell_toolbox.processing import mibi
from deepcell_toolbox.processing import watershed
from deepcell_toolbox.processing import pixelwise

from deepcell_toolbox.retinanet import retinamask_postprocess
from deepcell_toolbox.retinanet import retinamask_semantic_postprocess

from deepcell_toolbox.utils import correct_drift
from deepcell_toolbox.utils import erode_edges

from deepcell_toolbox.compute_overlap import compute_overlap  # pylint: disable=E0401

# alias for backwards compatibility
retinanet_to_label_image = retinamask_postprocess
retinanet_semantic_to_label_image = retinamask_semantic_postprocess

del absolute_import
del division
del print_function
