# Generated by Django 2.2.28 on 2023-03-21 16:02

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_application', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Deployment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(blank=True, choices=[('Todo', 'Todo'), ('Done', 'Done'), ('Failed', 'Failed')], default='Todo', max_length=8, null=True)),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='deployments', to='djangoldp_application.Application')),
            ],
            options={
                'verbose_name': 'deployment',
                'verbose_name_plural': 'deployments',
                'ordering': ['application__urlid', 'date'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:federation',
                'rdf_context': {'application': 'sib:application', 'date': 'sib:deploymentDate', 'status': 'sib:deploymentStatus'},
                'owner_field': 'application__creator',
                'container_path': '/deployments/',
                'serializer_fields': ['@id', 'date', 'status'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit', 'add'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['view'],
            },
        ),
    ]
