# Copyright (C) 2021 Satoshi Konno. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# To the extent possible under law, Sony Computer Science Laboratories, Inc has waived
# all copyright and related or neighboring rights to ECHONETLite-ObjectDatabase.
# This work is published from: Japan.
#
# GENERATED FROM objects.pl DO NOT EDIT THIS FILE.

from .reader import Manufacture, Object, Property

__std_mra_objects: dict = {}


def get_all_std_mra_objects() -> dict:
    return __std_mra_objects


# Super class (0x0000)
obj = Object("Super class", 0x00, 0x00)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "optional", "required"))
obj.add_property(Property(0x81, "Installation location", "", 0, "required", "required", "required"))
obj.add_property(Property(0x81, "Installation location", "", 0, "required", "required", "required"))
obj.add_property(Property(0x82, "Standard version information", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x83, "Identification number", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x83, "Identification number", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x84, "Measured instantaneous power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x85, "Measured cumulative power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x86, "Manufacturer's fault code", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x87, "Current limit setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x88, "Fault status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0x89, "Fault description", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8A, "Manufacturer code", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x8B, "Business facility code", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8C, "Product code", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8D, "Production number", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8E, "Production date", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8F, "Power-saving operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x93, "Location information", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x93, "Location information", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0x93, "Remote control setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x93, "Remote controll setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x97, "Current time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x98, "Current date setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x99, "Power limit setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x9A, "Cumulative operating time", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x9D, "Status change announcement property map", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9E, "Set property map", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9F, "Get property map", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x00)] = obj

# Node profile (0x0EF0)
obj = Object("Node profile", 0x0E, 0xF0)
obj.add_property(Property(0x80, "Operating status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0x82, "Version information", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x83, "Identification number", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x88, "Fault status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x89, "Fault description", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8A, "Manufacturer code", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x8B, "Business facility code", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8C, "Product code", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8D, "Production number", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8E, "Production date", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x9D, "Status change announcement property map", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9E, "Set property map", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9F, "Get property map", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xBF, "Unique identifier data", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD3, "Number of self-node instances", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Number of self-node classes", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Instance list notification", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xD6, "Self-node instance list S", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Self-node class list S", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x0E, 0xF0)] = obj

# Hybrid water heater (0x02A6)
obj = Object("Hybrid water heater", 0x02, 0xA6)
obj.add_property(Property(0xB0, "Automatic water heating setting", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0xB2, "Water heating status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xB3, "Heater status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xB6, "Hot water supply mode setting for auxiliary heat source machine", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Heater mode setting for auxiliary heat source machine.", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB8, "Linkage mode setting for solar power generation", "", 0, "required", "required", "required"))
obj.add_property(Property(0xB9, "Solar power generations utilization time", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC3, "Hot water supply status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE1, "Measured amount of hot water remaining in tank", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Tank capacity", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0xA6)] = obj

# Switch (supporting JEM-A/HA terminals) (0x05FD)
obj = Object("Switch (supporting JEM-A/HA terminals)", 0x05, 0xFD)
obj.add_property(Property(0xE0, "Connected device", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x05, 0xFD)] = obj

# Instantaneous water heater (0x0272)
obj = Object("Instantaneous water heater", 0x02, 0x72)
obj.add_property(Property(0x90, "ON timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Set value of ON timer relative time", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD0, "Hot water heating status", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Set value of hot water temperature", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD2, "Hot water warmer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD4, "Bath water volume setting 4", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD5, "Bath water volume setting 4 Maximum settable level", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Volume setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD7, "Mute setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDA, "Duration of Automatic operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDB, "Remaining Automatic operation time", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Set value of bath temperature", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Bath water heater status", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Bath Auto mode setting", "", 0, "required_o", "required_o", "optional"))
obj.add_property(Property(0xE4, "Bath additional boil-up operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Bath hot water adding operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Bath water temperature lowering operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Bath hot water volume setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Bath hot water volume setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Bathroom priority setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Bathroom priority setting", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Shower hot water supply status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Kitchen hot water supply status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Hot water warmer ON timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Set value of hot water warmer ON timer time", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Bath hot water volume setting 3", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Bath operation status monitor", "", 0, "optional", "notApplicable", "required"))
__std_mra_objects[(0x02, 0x72)] = obj

# Commercial showcase (0x03CE)
obj = Object("Commercial showcase", 0x03, 0xCE)
obj.add_property(Property(0xB0, "Operation mode", "", 0, "required", "required", "required"))
obj.add_property(Property(0xB0, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xBD, "Used to acquire measurements of discharge temperature.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0xD0, "This property indicates the type of the showcase.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "This property indicates the type of the showcase door.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "This property indicates refrigerator type, such as built-in or separate.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "This property indicates the shape of the showcase.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "This property indicates the purpose of the showcase, either refrigeration or freezing.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Indicates on/off status of lighting installed inside the showcase.", "", 0, "required", "optional", "required"))
obj.add_property(Property(0xE1, "Indicates ON/OFF status of lighting installed outside the showcase.", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0xE2, "Indicates on/off status of compressor when showcase and compressor are a single unit.", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Used to acquire internal temperature measurements inside the showcase.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Indicates rated power consumption necessary when showcase is cooling.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Indicates rated power consumption when heater is operating during showcase defrosting.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Indicates rated power consumption when showcase is operating fan motor.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Indicates on/off status of showcases with heater for hot function.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Indicates type of lighting installed inside the showcase.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Indicates type of lighting installed outside the showcase.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xED, "Indicates lighting level in % installed inside of the showcase.", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Indicates lighting level in % installed outside of the showcase.", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Set temperature setting of inside the case and acquire the current setting.", "", 0, "required", "required", "optional"))
__std_mra_objects[(0x03, 0xCE)] = obj

# Illuminance sensor (0x00D0)
obj = Object("Illuminance sensor", 0x00, 0xD0)
obj.add_property(Property(0xE0, "Measured illuminance value 1", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Measured illuminance value 2", "", 0, "required_c", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0xD0)] = obj

# Television (0x0602)
obj = Object("Television", 0x06, 0x02)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required_o", "required"))
obj.add_property(Property(0xB0, "Display control setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Character string setting acceptance status", "", 0, "required_o", "notApplicable", "required"))
obj.add_property(Property(0xB2, "Supported character codes", "", 0, "required_o", "notApplicable", "optional"))
obj.add_property(Property(0xB3, "Character string to present to the user", "", 0, "optional", "required", "optional"))
obj.add_property(Property(0xB4, "Length of character string accepted", "", 0, "required_o", "notApplicable", "optional"))
__std_mra_objects[(0x06, 0x02)] = obj

# EV charger and discharger (0x027E)
obj = Object("EV charger and discharger", 0x02, 0x7E)
obj.add_property(Property(0xC0, "Dischargeable capacity of vehicle mounted battery 1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Dischargeable capacity of vehicle mounted battery 2", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Dischargeable capacity of vehicle mounted battery 2", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Remaining dischargeable capacity of vehicle mounted battery 1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Remaining dischargeable capacity of vehicle mounted battery 2", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Remaining dischargeable capacity of vehicle mounted battery 2", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Remaining dischargeable capacity of vehicle mounted battery 3", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Rated charge capacity", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Rated discharge capacity", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable/dischargeable status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable/dischargeable status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable/dischargeable status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Minimum/maximum discharging electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Minimum/maximum charging current", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Minimum/maximum discharging current", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Charger/Discharger type", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Vehicle connection confirmation", "", 0, "notApplicable", "required", "notApplicable"))
obj.add_property(Property(0xCE, "Chargeable capacity of vehicle mounted battery", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Remaining chargeable capacity of vehicle mounted battery", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Used capacity of vehicle mounted battery 1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Used capacity of vehicle mounted battery 2", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Used capacity of vehicle mounted battery 2", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Rated voltage", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured instantaneous charging/discharging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured instantaneous charging/discharging current", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured instantaneous charging/discharging voltage", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Measured cumulative amount of discharging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Cumulative amount of discharging electric energy reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xD8, "Measured cumulative amount of charging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Cumulative amount of charging electric energy reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDB, "System interconnected type", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Charging method", "", 0, "required", "optional", "required"))
obj.add_property(Property(0xDC, "Charging method", "", 0, "required", "optional", "required"))
obj.add_property(Property(0xDD, "Discharging method", "", 0, "required", "optional", "required"))
obj.add_property(Property(0xDD, "Discharging method", "", 0, "required", "optional", "required"))
obj.add_property(Property(0xDE, "Purchasing electric power setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDF, "Re-interconnection permission setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Charging/Discharging electric power setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Remaining stored electricity of vehicle mounted battery1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Remaining stored electricity of vehicle mounted battery2", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Remaining stored electricity of vehicle mounted battery2", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Remaining stored electricity of vehicle mounted battery3", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Maintenance status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE6, "Vehicle ID", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Charging amount setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Charging amount setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Discharging electric energy setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Charging electric energy setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Discharging electric energy setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Charging current setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Discharging current setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Rated voltage (Independent)", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7E)] = obj

# Package-type commercial air conditioner (outdoor unit) (0x0157)
obj = Object("Package-type commercial air conditioner (outdoor unit)", 0x01, 0x57)
obj.add_property(Property(0xAB, "Special state", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB8, "Rated power consumption of outdoor unit", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBE, "Measured outdoor unit temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "Measured power consumption of outdoor unit", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Possible power savings for outdoor units", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDE, "Settings restricting power consumption of outdoor units", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xDF, "Minimum power consumption for restricted outdoor unit", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x01, 0x57)] = obj

# Humidity sensor (0x0012)
obj = Object("Humidity sensor", 0x00, 0x12)
obj.add_property(Property(0xE0, "Measured value of relative humidity", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x12)] = obj

# Mono functional lighting (0x0291)
obj = Object("Mono functional lighting", 0x02, 0x91)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0xB0, "Light level Setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x91)] = obj

# Power distribution board metering (0x0287)
obj = Object("Power distribution board metering", 0x02, 0x87)
obj.add_property(Property(0xB0, "Master rated capacity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Number of measurement channels (simplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Channel range specification for cumulative amount of electric power consumption measurement (simplex)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Measured cumulative amount of electric power consumption list (simplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB4, "Channel range specification for instantaneous current measurement (simplex)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB5, "Measured instantaneous current list (simplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB6, "Channel range specification for instantaneous power consumption measurement (simplex)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Measured instantaneous power consumption list (simplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB8, "Number of measurement channels (duplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB9, "Channel range specification for cumulative amount of electric power consumption measurement (duplex)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBA, "Measured cumulative amount of electric power consumption list (duplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Channel range specification for instantaneous current measurement (duplex)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBC, "Measured instantaneous current list (duplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBD, "Channel range specification for instantaneous power consumption measurement (duplex)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBE, "Measured instantaneous power consumption list (duplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC0, "Measured cumulative amount of electric energy (normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Measured cumulative amount of electric energy (reverse direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Unit for cumulative amounts of electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Historical data of measured cumulative amounts of electric energy (normal direction)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Historical data of measured cumulative amounts of electric energy (reverse direction)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC6, "Measured instantaneous amount of electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Measured instantaneous currents", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Measured instantaneous voltages", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Measurement channel 1", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Measurement channel 2", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Measurement channel 3", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measurement channel 4", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measurement channel 5", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measurement channel 6", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Measurement channel 7", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Measurement channel 8", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Measurement channel 9", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Measurement channel 10", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDA, "Measurement channel 11", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "Measurement channel 12", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Measurement channel 13", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Measurement channel 14", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDE, "Measurement channel 15", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDF, "Measurement channel 16", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Measurement channel 17", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Measurement channel 18", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Measurement channel 19", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measurement channel 20", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Measurement channel 21", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Measurement channel 22", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Measurement channel 23", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Measurement channel 24", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE8, "Measurement channel 25", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE9, "Measurement channel 26", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Measurement channel 27", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Measurement channel 28", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Measurement channel 29", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xED, "Measurement channel 30", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEE, "Measurement channel 31", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEF, "Measurement channel 32", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x87)] = obj

# Electric water heater (0x026B)
obj = Object("Electric water heater", 0x02, 0x6B)
obj.add_property(Property(0x90, "ON timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Automatic water heating setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB0, "Automatic water heating setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xB1, "Automatic water temperature control setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Water heater status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Water heater status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xB3, "Water heating temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Manual water heating stop days setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB5, "Relative time setting value for manual water heating OFF", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB6, "Tank operation mode setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Daytime reheating permission setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Daytime reheating permission setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC1, "Measured temperature of water in water heater", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Alarm status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xC3, "Hot water supply status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xC4, "Relative time setting for keeping bath temperature", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC7, "Participation in energy shift", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC8, "Standard time to start heating", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Number of energy shifts", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Daytime heating shift time 1", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xCB, "Expected electric energy at daytime heating shift time 1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Consumption of electric energy per hour 1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Daytime heating shift time 2", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xCE, "Expected electric energy at daytime heating shift time 2", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Consumption of electric energy per hour 2", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Temperature of supplied water setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD3, "Bath water temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD4, "Bath water volume setting4", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD5, "Bath water volume setting4 maximum settable level", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Volume setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD7, "Mute setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD8, "Remaining hot water volume", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Surplus electric energy power prediction value", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDB, "Rated power consumption of H/P unit in wintertime", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Rated power consumption of H/P unit in in-between seasons", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Rated power consumption of H/P unit in summertime", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Bath water volume setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Measured amount of water remaining in tank", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Tank capacity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Automatic Bath Water Heating Mode Setting", "", 0, "required_o", "required_o", "optional"))
obj.add_property(Property(0xE4, "Manual bath reheating operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Addition of hot water function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Manual bath hot water addition function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Slight bath water temperature lowering function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Manual lukewarm water temperature lowering function setting.", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Bath water volume setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Bath water volume setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Bathroom priority setting", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Bath Operation Status Monitor", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xEE, "Bath water volume setting 3", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x6B)] = obj

# General lighting (0x0290)
obj = Object("General lighting", 0x02, 0x90)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0x90, "ON timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "Time set by OFF timer", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Light level", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Light color setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Light color setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Light color setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Light level step setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Light color step setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Maximum specifiable values", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB5, "Maximum value of settable level for night lighting", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB6, "Lighting mode setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB7, "Light level setting for main lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB8, "Light level step setting for main lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB9, "Light level setting for night lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBA, "Light level step setting for night lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBB, "Light color setting for main lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBC, "Light color level step setting for main lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBD, "Light color setting for night lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBE, "Light color level step setting for night lighting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBF, "Lighting mode status in auto mode", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC0, "RGB setting for color lighting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x90)] = obj

# Storage battery (0x027D)
obj = Object("Storage battery", 0x02, 0x7D)
obj.add_property(Property(0x83, "Identification number", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x97, "Current time setting", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0x98, "Current date setting", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0xA0, "AC effective capacity (charging)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA1, "AC effective capacity (discharging)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA2, "AC chargeable capacity", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA3, "AC dischargeable capacity", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA4, "AC chargeable electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA5, "AC dischargeable electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA6, "AC charge upper limit setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA7, "AC discharge lower limit setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA8, "AC measured cumulative charging electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA9, "AC measured cumulative discharging electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xAA, "AC charge amount setting value", "", 0, "required", "required", "required"))
obj.add_property(Property(0xAB, "AC discharge amount setting value", "", 0, "required", "required", "required"))
obj.add_property(Property(0xC1, "Charging method", "", 0, "required", "optional", "required"))
obj.add_property(Property(0xC2, "Discharging method", "", 0, "required", "optional", "required"))
obj.add_property(Property(0xC7, "AC rated electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric power", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric power", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Minimum/maximum discharging electric power", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Minimum/maximum discharging electric power", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Minimum/maximum charging current", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Minimum/maximum discharging current", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Re-interconnection permission setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCD, "Operation permission setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCE, "Independent operation permission setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCF, "Working operation status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xCF, "Working operation status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xD0, "Rated electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Rated capacity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Rated voltage", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured instantaneous charging/discharging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured instantaneous charging/discharging current", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured instantaneous charging/discharging voltage", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Measured cumulative discharging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Measured cumulative discharging electric energy reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xD8, "Measured cumulative charging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Measured cumulative charging electric energy reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xDB, "System-interconnected type", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "System-interconnected type", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Minimum/maximum charging power (Independent)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Minimum/maximum discharging power (Independent)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDE, "Minimum/maximum charging current (Independent)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDF, "Minimum/maximum discharging current (Independent)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Charging/discharging amount setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Charging/discharging amount setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Charging/discharging amount setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Charging/discharging amount setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Remaining stored electricity 1", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Remaining stored electricity 2", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Remaining stored electricity 3", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Battery state of health", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Battery type", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Charging amount setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Discharging amount setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Charging amount setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Discharging amount setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Charging electric energy setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Discharging electric energy setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Charging current setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Discharging current setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Rated voltage (Independent)", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7D)] = obj

# Package-type commercial air conditioner (indoor unit) (except those for facilities) (0x0156)
obj = Object("Package-type commercial air conditioner (indoor unit) (except those for facilities)", 0x01, 0x56)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0xAC, "Thermostat state", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xAE, "Current function (automatic operation mode)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xB0, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xB3, "Temperature setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xBB, "Measured indoor unit temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "Power consumption range for indoor units", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x01, 0x56)] = obj

# Rice cooker (0x03BB)
obj = Object("Rice cooker", 0x03, 0xBB)
obj.add_property(Property(0x90, "Rice cooking reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "Rice cooking reservation time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Rice cooking reservation relative time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Cover closure status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Rice cooking status", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Rice cooking control setting", "", 0, "required_o", "required_o", "optional"))
obj.add_property(Property(0xE1, "Warmer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Inner pot removal status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Cover removal status", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x03, 0xBB)] = obj

# High-voltage smart electric energy meter (0x028A)
obj = Object("High-voltage smart electric energy meter", 0x02, 0x8A)
obj.add_property(Property(0xC1, "Monthly maximum electric power demand", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Cumulative maximum electric power demand", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Electric power demand at fixed time (30-minute average electric power)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Number of effective digits of electric power demand", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Unit of electric power demand", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Historical data of measured electric power demand", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Unit of cumulative maximum electric power demand", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Measurement data of reactive electric power consumption (lag) for power factor measurement", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Measurement data of cumulative amount of reactive electric power consumption (lag) at fixed time for power factor measurement", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Number of effective digits for measurement data of cumulative amount of reactive electric power consumption (lag) for power factor measurement", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Unit of measurement data of cumulative amount of reactive electric power consumption (lag)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "Historical data of measurement data of cumulative amount of reactive electric power consumption (lag) for power factor measurement", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Coefficient", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Multiplying factor for coefficient", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Fixed date", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xE2, "Measured cumulative amounts of active electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Cumulative amounts of active electric energy at fixed time", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Measurement data of cumulative amounts of active electric energy for power factor measurement", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Number of effective digits for cumulative amount of active electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Unit of cumulative amounts of effective electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Historical data of measured cumulative amount of active electric energy", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x8A)] = obj

# Cooking heater (0x03B9)
obj = Object("Cooking heater", 0x03, 0xB9)
obj.add_property(Property(0x96, "Relative time settings of off timers", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA1, "Child lock setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA2, "Radiant heater lock setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Heating status", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Heating setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "All stop setting", "", 0, "notApplicable", "required_o", "optional"))
obj.add_property(Property(0xE0, "Heating modes of stoves", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Heating temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Heating power setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x03, 0xB9)] = obj

# VOC sensor (0x001D)
obj = Object("VOC sensor", 0x00, 0x1D)
obj.add_property(Property(0xB0, "Detection threshold level", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "VOC detection status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE0, "Measured value of VOC concentration", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x1D)] = obj

# Bathroom heater dryer (0x0273)
obj = Object("Bathroom heater dryer", 0x02, 0x73)
obj.add_property(Property(0x90, "On timer reservation setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "On timer setting value", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "On relative timer setting value", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "Off timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "OFF timer setting value", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "Off relative timer setting value", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Operation setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB0, "Operation setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB1, "Ventilation operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Bathroom prewarming operation setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB2, "Bathroom prewarming operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Bathroom heating operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Bathroom drying operation setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB5, "Cool air circulation operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB6, "Mist sauna operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Water mist operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBA, "Measured value of bathroom relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Measured value of bathroom temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Ventilation air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCF, "Filter cleaning reminder sign setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Human body detection status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "On timer reservation setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "On timer reservation setting 2", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x73)] = obj

# Commercial show case outdoor unit (0x03D4)
obj = Object("Commercial show case outdoor unit", 0x03, 0xD4)
obj.add_property(Property(0xAA, "Indicates that the showcase freezer is in an exceptional status.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB0, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xB0, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xBE, "Used to acquire measurements of outdoor air temperature.", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0xE2, "Indicates compressor ON/OFF status.", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x03, 0xD4)] = obj

# Fuel cell (0x027C)
obj = Object("Fuel cell", 0x02, 0x7C)
obj.add_property(Property(0xC1, "Measured temperature of water in water heater", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Rated power generation output", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Rated power generation output", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Heating value of hot water storage tank", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Measured instantaneous power generation output", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Measured cumulative power generation output", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Cumulative power generation output reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xC6, "Cumulative energy generation output reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xC7, "Measured instantaneous gas consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Measured cumulative gas consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Cumulative gas consumption reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xCA, "Power generation setting", "", 0, "notApplicable", "optional", "optional"))
obj.add_property(Property(0xCA, "Power generation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCB, "Power generation status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Power generation status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xCC, "Measured in-house instantaneous power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Measured in-house cumulative power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Measured in-house cumulative energy consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "In-house cumulative power consumption reset", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xCE, "In-house cumulative energy consumption reset", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xD0, "System interconnected type", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "System interconnected type", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Power generation request time setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xD2, "Designated power generation status", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xE1, "Measured remaining hot water amount", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Tank capacity", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7C)] = obj

# Water flowmeter (0x0281)
obj = Object("Water flowmeter", 0x02, 0x81)
obj.add_property(Property(0xD0, "Water flowmeter classification", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Owner classification", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Measured cumulative amount of flowing water", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Unit for measured Cumulative amounts of flowing water", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amount of flowing water", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Detection of abnormal value in metering data", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE4, "Security data information", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "ID number setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Verification expiration information", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x81)] = obj

# Home air conditioner (0x0130)
obj = Object("Home air conditioner", 0x01, 0x30)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0x8F, "Power-saving operation setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0x90, "ON timer-based reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting (time)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "ON timer setting (relative time)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer-based reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "OFF timer setting (time)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "OFF timer setting (relative time)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA0, "Air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA0, "Air flow rate setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xA1, "Automatic control of air flow direction setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA3, "Automatic swing of air flow setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA4, "Air flow direction (vertical) setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA5, "Air flow direction (horizontal) setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xAA, "Special state", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xAB, "Non-priority state", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB0, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xB1, "Automatic temperature control setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Normal/highspeed/silent operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Set temperature value", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB4, "Set value of relative humidity in dehumidifying mode", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB5, "Set temperature value in cooling mode", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB6, "Set temperature value in heating mode", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Set temperature value in dehumidifying mode", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB8, "Rated power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB9, "Measured value of current consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBA, "Measured value of room relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Measured value of room temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Measured value of room temperature", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xBC, "Set temperature value of user remote control", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBD, "Measured cooled air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBE, "Measured outdoor air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBF, "Relative temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Ventilation function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC1, "Humidifier function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC2, "Ventilation air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC4, "Degree of humidification setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC6, "Mounted air cleaning method", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Air purifier function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC8, "Mounted air refresh method", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Air refresher function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCA, "Mounted self-cleaning method", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Self-cleaning function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCC, "Special function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCD, "Operation status of components", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "Thermostat setting override function", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xCE, "Thermostat setting override function", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCF, "Air purification mode setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD0, "Buzzer", "", 0, "notApplicable", "optional", "notApplicable"))
__std_mra_objects[(0x01, 0x30)] = obj

# Electric energy sensor (0x0022)
obj = Object("Electric energy sensor", 0x00, 0x22)
obj.add_property(Property(0xE0, "Cumulative amounts of electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Medium-capacity sensor instantaneous electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Small-capacity sensor instantaneous electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Large-capacity sensor instantaneous electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Cumulative amounts of electric energy measurement log", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Cumulative amounts of electric energy measurement log", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Effective voltage value", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x22)] = obj

# Washer and dryer (0x03D3)
obj = Object("Washer and dryer", 0x03, 0xD3)
obj.add_property(Property(0x90, "On timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "On timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Relative time-based on timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Door/cover open/close status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Washer and dryer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD0, "Washer and dryer cycle setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Washer and dryer cycle setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD2, "Drying cycle setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD3, "Washer and dryer cycle option list 1", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Washer and dryer cycle option list 2", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Washer and dryer cycle option list 3", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Water flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD7, "Rotation speed for spin drying setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD8, "Degree of drying setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDB, "Remaining washing time", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Remaining drying time", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDF, "Elapsed time on the ON timer", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Presoaking time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Current stage of washer and dryer cycle", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Water volume setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE4, "Water volume setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Washing time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Number of times of rinsing setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Rinsing process setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Spin drying time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Drying time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Warm water setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Bathtub water recycle setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Wrinkling minimization setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Time remaining to complete washer and dryer cycle", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEE, "Door/cover lock setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Washer and dryer cycle", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x03, 0xD3)] = obj

# Electrically operated rain sliding door/shutter (0x0263)
obj = Object("Electrically operated rain sliding door/shutter", 0x02, 0x63)
obj.add_property(Property(0x89, "Fault description (Recoverable faults)", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0x90, "Timer operation setting", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0xD0, "Opening speed setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Closing speed setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD2, "Operation time", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Open/close operation setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xE1, "Degree-of-opening setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Blind angle setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Opening/closing speed setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Electric lock setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Remote operation setting status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE9, "Selective degree-of-opening setting", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0xEA, "Open/closed status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xED, "Slit degree-of-opening", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "One-time opening speed setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "One-time closing speed setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x63)] = obj

# CO2 sensor (0x001B)
obj = Object("CO2 sensor", 0x00, 0x1B)
obj.add_property(Property(0xE0, "Measured value of CO2 concentration", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x1B)] = obj

# Current sensor (0x0023)
obj = Object("Current sensor", 0x00, 0x23)
obj.add_property(Property(0xE0, "Measured current value 1", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Rated voltage to be measured", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Measured current value 2", "", 0, "required_c", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x23)] = obj

# EV Charger (0x02A1)
obj = Object("EV Charger", 0x02, 0xA1)
obj.add_property(Property(0xC5, "Rated charge capacity", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Minimum/maximum charging electric current", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Charger type", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Vehicle connection confirmation", "", 0, "notApplicable", "required", "optional"))
obj.add_property(Property(0xCE, "Chargeable capacity of vehicle mounted battery", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Remaining chargeable capacity of vehicle mounted battery", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Used capacity of vehicle mounted battery 1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Rated voltage", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured instantaneous charging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Measured cumulative amount of charging electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Cumulative amount of charging electric energy reset setting", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xDA, "Operation mode setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xE2, "Remaining stored electricity of vehicle mounted battery1", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Remaining stored electricity of vehicle mounted battery3", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Vehicle ID", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Charging amount setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Charging electric energy setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Charging current setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0xA1)] = obj

# Watt-hour meter (0x0280)
obj = Object("Watt-hour meter", 0x02, 0x80)
obj.add_property(Property(0xE0, "Cumulative amounts of electric energy measurement value", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Cumulative amounts of electric energy unit", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Cumulative amounts of electric energy measurement log 1", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x80)] = obj

# Emergency button (0x0003)
obj = Object("Emergency button", 0x00, 0x03)
obj.add_property(Property(0xB1, "Emergency occurrence status", "", 0, "required", "notApplicable", "required"))
obj.add_property(Property(0xBF, "Emergency occurrence status resetting", "", 0, "notApplicable", "optional", "notApplicable"))
__std_mra_objects[(0x00, 0x03)] = obj

# Household solar power generation (0x0279)
obj = Object("Household solar power generation", 0x02, 0x79)
obj.add_property(Property(0x83, "Identification number", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x97, "Current time setting", "", 0, "required_c", "optional", "optional"))
obj.add_property(Property(0x98, "Current date setting", "", 0, "required_c", "optional", "optional"))
obj.add_property(Property(0xA0, "Output power control setting 1", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xA1, "Output power control setting 2", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xA2, "Function to control purchase surplus electricity setting", "", 0, "required_c", "optional", "optional"))
obj.add_property(Property(0xB0, "Output power controlling schedule", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Next access date and time", "", 0, "required_c", "notApplicable", "required"))
obj.add_property(Property(0xB2, "Function to control the type of surplus electricity purchase", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xB3, "Output power change time setting value", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB4, "Upper limit clip setting value", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC0, "Operation power factor setting value", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "FIT contract type", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC2, "Self-consumption type", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Capacity approved by equipment", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Conversion coefficient", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "System-interconnected type", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "System-interconnected type", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Output power restraint status", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Measured instantaneous amount of electricity generated", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Measured cumulative amount of electric energy generated", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Resetting cumulative amount of electric energy generated", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xE3, "Measured cumulative amount of electric energy sold", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Resetting cumulative amount of electric energy sold", "", 0, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xE5, "Power generation output limit setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Power generation output limit setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Limit setting for the amount of electricity sold", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Rated power generation output (System-interconnected)", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Rated power generation output (System-interconnected)", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0xE9, "Rated power generation output (Independent)", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x79)] = obj

# Floor heater (0x027B)
obj = Object("Floor heater", 0x02, 0x7B)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0x90, "ON timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "Time set by ON timer", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Relative ON timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "Time set by OFF timer", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "Relative OFF timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Maximum temperature level", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE0, "Set temperature value", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE1, "Set temperature level by 15 steps", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE2, "Measured room temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured floor temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured floor temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Zone change setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Special operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Daily timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Daily timer setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Daily timer setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Rated power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Power consumption measurement method", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7B)] = obj

# Bath heating status sensor (0x0016)
obj = Object("Bath heating status sensor", 0x00, 0x16)
obj.add_property(Property(0xB0, "Detection threshold level", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Bath heating detection status", "", 0, "required", "notApplicable", "required"))
__std_mra_objects[(0x00, 0x16)] = obj

# Cold or hot water heat source equipment (0x027A)
obj = Object("Cold or hot water heat source equipment", 0x02, 0x7A)
obj.add_property(Property(0x90, "ON timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Relative ON timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "Time set by OFF timer", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "Relative OFF timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Cold water temperature setting 2 Maximum allowable setting level", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0xD2, "Warm water temperature setting 2 Maximum allowable setting level", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0xE0, "Operation mode setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Water temperature setting 1", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE2, "Water temperature setting 2", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE3, "Measured temperature of outward water (Exit water Temperature)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Measured temperature of inward water (Entrance water Temperature)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Special operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Daily timer setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Daily timer setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Daily timer setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Rated power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Power consumption measurement method", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7A)] = obj

# Smart electric energy meter for sub-metering (0x028D)
obj = Object("Smart electric energy meter for sub-metering", 0x02, 0x8D)
obj.add_property(Property(0xD3, "Electric energy coefficient", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Unit for cumulative amount of electric energy (normal and reverse directions)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Number of effective digits for cumulative amounts of electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Electric current coefficient", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Voltage coefficient", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xE1, "Measured cumulative amount of electric energy(normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amounts of electric energy (normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured cumulative amount of electric energy (reverse direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Historical data of measured cumulative amounts of electric energy (reverse direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Measured instantaneous electric power", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE8, "Measured instantaneous currents", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE9, "Measured instantaneous voltages", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Cumulative amounts of electric energy measured at fixed time(normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Cumulative amounts of electric energy measured at fixed time(reverse direction)", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x8D)] = obj

# Lighting system (0x02A3)
obj = Object("Lighting system", 0x02, 0xA3)
obj.add_property(Property(0xB0, "Light level setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Scene control setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC1, "Number that can assign scene control setting", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0xA3)] = obj

# Ventilation fan (0x0133)
obj = Object("Ventilation fan", 0x01, 0x33)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0xA0, "Set value of ventilation air flow rate", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBF, "Ventilation Auto setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x01, 0x33)] = obj

# Electric lock (0x026F)
obj = Object("Electric lock", 0x02, 0x6F)
obj.add_property(Property(0xE0, "Lock setting1", "", 0, "required", "required", "required"))
obj.add_property(Property(0xE1, "Lock setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Lock status of door guard", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Door open/close status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Occupant/ non-occupant status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Alarm status", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE6, "Auto lock mode setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Battery level", "", 0, "optional", "optional", "required"))
__std_mra_objects[(0x02, 0x6F)] = obj

# Gas meter (0x0282)
obj = Object("Gas meter", 0x02, 0x82)
obj.add_property(Property(0xE0, "Cumulative amount of gas consumption measurement value", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Cumulative amounts of gas consumption measurement log", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x82)] = obj

# Air conditioner ventilation fan (0x0134)
obj = Object("Air conditioner ventilation fan", 0x01, 0x34)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0xA0, "Set value of ventilation air flow rate", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Ventilation mode automatic setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Ventilation method setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Ventilation mode setting", "", 0, "optional", "optional", "required"))
obj.add_property(Property(0xB3, "Cooling / heating high-low setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Set value of room relative humidity", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB9, "Measured value of electric current consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBA, "Measured value of room relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBE, "Measured value of outdoor air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBF, "Ventilation auto setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Measured value of CO2 concentration", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Smoke (cigarette) detection status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Pollution detection status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Measured value of outdoor relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Measured value of return air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Measured value of return relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Measured value of charging air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured value of charging relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured value of discharging air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured value of discharging air relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Heat exchanger operation setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x01, 0x34)] = obj

# Controller (0x05FF)
obj = Object("Controller", 0x05, 0xFF)
obj.add_property(Property(0xC0, "Controller ID", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Number of devices controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Index", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC3, "Device ID", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Device type", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Name", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Connection status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Business code of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Business code of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Product code of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Product code of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Manufacture date of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Manufacture date of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Registerd information renewal date of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Registerd information renewal date of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Registerd information renewal version information of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Registerd information renewal version information of the device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Place to install device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Fault status of device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "Set property map for device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Get property map for device to be controlled", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Address of installation location", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x05, 0xFF)] = obj

# Extended lighting system (0x02A4)
obj = Object("Extended lighting system", 0x02, 0xA4)
obj.add_property(Property(0xB0, "Light level setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Scene control setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC1, "Number that can assign scene control setting.", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Power consumption rate list", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Power consumption when fully lighted", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Possible power savings", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Power consumption limit setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC6, "Automatic operation controlling setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC7, "Fading control change time setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0xA4)] = obj

# Temperature sensor (0x0011)
obj = Object("Temperature sensor", 0x00, 0x11)
obj.add_property(Property(0xE0, "Measured temperature value", "", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x11)] = obj

# Human detection sensor (0x0007)
obj = Object("Human detection sensor", 0x00, 0x07)
obj.add_property(Property(0xB0, "Detection threshold level", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Human detection status", "", 0, "required", "notApplicable", "required"))
__std_mra_objects[(0x00, 0x07)] = obj

# Refrigerator (0x03B7)
obj = Object("Refrigerator", 0x03, 0xB7)
obj.add_property(Property(0xA0, "Quick freeze function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA1, "Quick refrigeration function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA4, "Icemaker setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA5, "Icemaker operation status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xA6, "Icemaker tank status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xA8, "Refrigerator compartment humidification function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA9, "Vegetable compartment humidification function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xAD, "Deodorization function setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Door open/close status", "", 0, "required_o", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Door open warning", "", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xB2, "Refrigerator compartment door status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB3, "Freezer compartment door status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB4, "Ice compartment door status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB5, "Vegetable compartment door status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB6, "Multi-refrigerating mode compartment door status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Measured refrigerator compartment temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Measured freezer compartment temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured subzero-fresh compartment temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured vegetable compartment temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured multi-refrigerating mode compartment temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Compressor rotation speed", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDA, "Measured electric current consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Rated power consumption", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Maximum allowable temperature setting level", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Refrigerator compartment temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Freezer compartment temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE4, "Ice compartment temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Vegetable compartment temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Multi-refrigerating mode compartment temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Refrigerator compartment temperature level setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Freezer compartment temperature level setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Ice compartment temperature level setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Vegetable compartment temperature level setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Multi-refrigerating mode compartment temperature level setting", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x03, 0xB7)] = obj

# Air cleaner (0x0135)
obj = Object("Air cleaner", 0x01, 0x35)
obj.add_property(Property(0x80, "Operation status", "", 0, "required", "required", "required"))
obj.add_property(Property(0xA0, "Air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Air pollution detection status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Smoke (cigarette) detection status", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Optical catalyst operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Filter change notice", "", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x01, 0x35)] = obj

# Low-voltage smart electric energy meter (0x0288)
obj = Object("Low-voltage smart electric energy meter", 0x02, 0x88)
obj.add_property(Property(0xD3, "Coefficient", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Number of effective digits for cumulative amounts of electric energy", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Measured cumulative amount of electric energy (normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Unit for cumulative amounts of electric energy (normal and reverse directions)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amounts of electric energy 1 (normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured cumulative amount of electric energy (reverse direction)", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Historical data of measured cumulative amounts of electric energy 1 (reverse direction)", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved 1", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xE7, "Measured instantaneous electric power", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE8, "Measured instantaneous currents", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Cumulative amounts of electric energy measured at fixed time (normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Cumulative amounts of electric energy measured at fixed time (reverse direction)", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Historical data of measured cumulative amounts of electric energy 2 (normal and reverse directions)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xED, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved 2", "", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x88)] = obj
