# Generated by Django 5.0.2 on 2024-03-01 12:07

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Flow',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('flow_name', models.CharField(max_length=255, unique=True)),
                ('flow_display_name', models.CharField(blank=True, max_length=255, null=True)),
                ('in_current_code_base', models.BooleanField(blank=True, default=True)),
            ],
        ),
        migrations.CreateModel(
            name='ExecutedFlow',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('flow_id_snapshot', models.BigIntegerField(blank=True, null=True)),
                ('flow_name_snapshot', models.CharField(blank=True, max_length=255, null=True)),
                ('start_time', models.DateTimeField(auto_now_add=True)),
                ('end_time', models.DateTimeField(blank=True, null=True)),
                ('executed_by', models.CharField(blank=True, max_length=255, null=True)),
                ('flow_complete', models.BooleanField(default=False)),
                ('status', models.CharField(choices=[('complete', 'Complete'), ('pending', 'Pending'), ('failed', 'Failed')], default='pending', max_length=20)),
                ('last_checkpoint_datetime', models.DateTimeField(auto_now_add=True)),
                ('flow_snapshot', models.JSONField(default=dict)),
                ('exceptions', models.JSONField(default=dict)),
                ('flow', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='flow_runs', to='django_flow_forge.flow')),
            ],
        ),
        migrations.CreateModel(
            name='FlowTask',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('task_name', models.CharField(max_length=255)),
                ('task_output', models.JSONField(default=dict)),
                ('nested', models.BooleanField(blank=True, default=False)),
                ('depends_bidirectionally_with', models.ManyToManyField(blank=True, to='django_flow_forge.flowtask')),
                ('depends_on', models.ManyToManyField(blank=True, to='django_flow_forge.flowtask')),
                ('flow', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tasks', to='django_flow_forge.flow')),
            ],
            options={
                'unique_together': {('flow', 'task_name')},
            },
        ),
        migrations.CreateModel(
            name='ExecutedTask',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('task_snapshot_id', models.BigIntegerField(blank=True, null=True)),
                ('task_name_snapshot', models.CharField(blank=True, max_length=255, null=True)),
                ('task_snapshot', models.JSONField(default=dict)),
                ('output', models.JSONField(default=dict, null=True)),
                ('start_time', models.DateTimeField(auto_now_add=True)),
                ('end_time', models.DateTimeField(blank=True, null=True)),
                ('task_complete', models.BooleanField(default=False)),
                ('status', models.CharField(choices=[('complete', 'Complete'), ('pending', 'Pending'), ('failed', 'Failed')], default='pending', max_length=20)),
                ('exceptions', models.JSONField(default=dict)),
                ('flow_run', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='task_runs', to='django_flow_forge.executedflow')),
                ('task', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='runs', to='django_flow_forge.flowtask')),
            ],
        ),
        migrations.AddField(
            model_name='executedflow',
            name='executed_tasks',
            field=models.ManyToManyField(blank=True, related_name='executed_tasks', to='django_flow_forge.flowtask'),
        ),
        migrations.CreateModel(
            name='MLResult',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('experiment', models.CharField(blank=True, max_length=255, null=True)),
                ('dataset', models.CharField(blank=True, max_length=255, null=True)),
                ('algorithm', models.CharField(blank=True, max_length=255, null=True)),
                ('parameters', models.JSONField(default=dict)),
                ('metrics', models.JSONField(default=dict)),
                ('result_file_path', models.CharField(blank=True, max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('notes', models.TextField(blank=True)),
                ('executed_flow', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ml_runs', to='django_flow_forge.executedflow')),
            ],
        ),
    ]
