# django-flow-forge

This is a module built for Data Scientists and Data Engineers, here to help you forge your Data Ops or ML Ops processes in to simple, flexible and impactful work flows, steering clear of the unnecessary complexities of other packages and vendor lock-in that plague many projects.

![mlops_gif](https://github.com/eddyojb88/django-flow-forge/assets/22086433/9ea13500-2019-4145-995f-1fd855f51c74)

# Motivation

[Read the Docs](https://eddyojb88.github.io/django-flow-forge/) for more info on this

# Features

- Easily define your flows / pipeline processes as a DAG
- Visualize your flows for stakeholders, both in planning and development phases (inspired by Kedro)
- Simple pipeline registration and execution through a script, Django website or via an API by plugging in Django-ninja (Fast API for Django))
- Task monitoring and visualization of outputs and failures.
- Visualise pipeline process outputs and failures for each task (inspired by Kedro)
- Compare data science experiment results easily
- Serve your models by plugging in Django Ninja
- A familiar environment for Django users, minimizing the learning curve
- Leverage Django's robust security
- Leverage Django's existing scalability features, including Django Celery and flexbility with Kubernetes engines, without the worry of vendor lock-in
- Encourages teams to move away from Notebooks, which cause a plethora of issues

### Example stakeholder facing development visualisation 

<img width="1057" alt="Screenshot 2024-02-27 at 11 45 02" src="https://github.com/eddyojb88/django-flow-forge/assets/22086433/36e80d55-4968-40e1-bf73-9eaef5247a8f">

# Quick Start

[See this page in the Docs](https://eddyojb88.github.io/django-flow-forge/installation/).
