# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.ai_action_set_metadata_after_running_inner import AIActionSetMetadataAfterRunningInner
from edgeimpulse_api.models.ai_actions_config_step import AIActionsConfigStep
from edgeimpulse_api.models.ai_actions_data_category import AIActionsDataCategory

class UpdateAIActionRequest(BaseModel):
    name: Optional[StrictStr] = Field(None, description="User-provided name. If no name is set then displayName on the action will be automatically configured based on the transformation block.")
    steps: List[AIActionsConfigStep] = ...
    data_category: AIActionsDataCategory = Field(..., alias="dataCategory")
    data_metadata_key: Optional[StrictStr] = Field(None, alias="dataMetadataKey", description="Metadata key to filter on. Required if dataCategory is equal to \"dataWithoutMetadataKey\" or \"dataWithMetadata\".")
    data_metadata_value: Optional[StrictStr] = Field(None, alias="dataMetadataValue", description="Metadata value to filter on. Required if dataCategory is equal to \"dataWithMetadata\".")
    set_metadata_after_running: List[AIActionSetMetadataAfterRunningInner] = Field(..., alias="setMetadataAfterRunning", description="After the action runs, add this key/value pair as metadata on the affected samples.")
    sort_order: Optional[StrictInt] = Field(None, alias="sortOrder", description="Numeric value (1..n) where this action should be shown in the action list (and in which order the actions should run when started from a data source).")
    __properties = ["name", "steps", "dataCategory", "dataMetadataKey", "dataMetadataValue", "setMetadataAfterRunning", "sortOrder"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> UpdateAIActionRequest:
        """Create an instance of UpdateAIActionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in set_metadata_after_running (list)
        _items = []
        if self.set_metadata_after_running:
            for _item in self.set_metadata_after_running:
                if _item:
                    _items.append(_item.to_dict())
            _dict['setMetadataAfterRunning'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateAIActionRequest:
        """Create an instance of UpdateAIActionRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UpdateAIActionRequest.construct(**obj)

        _obj = UpdateAIActionRequest.construct(**{
            "name": obj.get("name"),
            "steps": [AIActionsConfigStep.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "data_category": obj.get("dataCategory"),
            "data_metadata_key": obj.get("dataMetadataKey"),
            "data_metadata_value": obj.get("dataMetadataValue"),
            "set_metadata_after_running": [AIActionSetMetadataAfterRunningInner.from_dict(_item) for _item in obj.get("setMetadataAfterRunning")] if obj.get("setMetadataAfterRunning") is not None else None,
            "sort_order": obj.get("sortOrder")
        })
        return _obj

