# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.akida_edge_learning_config import AkidaEdgeLearningConfig
from edgeimpulse_api.models.anomaly_capacity import AnomalyCapacity
from edgeimpulse_api.models.augmentation_policy_image_enum import AugmentationPolicyImageEnum
from edgeimpulse_api.models.augmentation_policy_spectrogram import AugmentationPolicySpectrogram
from edgeimpulse_api.models.block_parameters import BlockParameters
from edgeimpulse_api.models.keras_model_type_enum import KerasModelTypeEnum
from edgeimpulse_api.models.keras_model_variant_enum import KerasModelVariantEnum
from edgeimpulse_api.models.keras_visual_layer import KerasVisualLayer

class SetKerasParameterRequest(BaseModel):
    mode: Optional[StrictStr] = Field(None, description="Whether to use visual or expert mode.")
    minimum_confidence_rating: Optional[float] = Field(None, alias="minimumConfidenceRating", description="DEPRECATED, use \"setImpulseThresholds\" instead. Minimum confidence score, if the neural network scores a sample below this threshold it will be flagged as uncertain.")
    selected_model_type: Optional[KerasModelTypeEnum] = Field(None, alias="selectedModelType")
    script: Optional[StrictStr] = Field(None, description="Raw Keras script (only used in expert mode)")
    visual_layers: Optional[List[KerasVisualLayer]] = Field(None, alias="visualLayers", description="The visual layers for the neural network (only in visual mode).")
    training_cycles: Optional[StrictInt] = Field(None, alias="trainingCycles", description="Number of training cycles (only in visual mode).")
    learning_rate: Optional[float] = Field(None, alias="learningRate", description="Learning rate (between 0 and 1) (only in visual mode).")
    batch_size: Optional[float] = Field(None, alias="batchSize", description="Batch size used during training (only in visual mode).")
    train_test_split: Optional[float] = Field(None, alias="trainTestSplit", description="Train/test split (between 0 and 1)")
    auto_class_weights: Optional[StrictBool] = Field(None, alias="autoClassWeights", description="Whether to automatically balance class weights, use this for skewed datasets.")
    use_learned_optimizer: Optional[StrictBool] = Field(None, alias="useLearnedOptimizer", description="Use learned optimizer and ignore learning rate.")
    augmentation_policy_image: Optional[AugmentationPolicyImageEnum] = Field(None, alias="augmentationPolicyImage")
    augmentation_policy_spectrogram: Optional[AugmentationPolicySpectrogram] = Field(None, alias="augmentationPolicySpectrogram")
    profile_int8: Optional[StrictBool] = Field(None, alias="profileInt8", description="Whether to profile the i8 model (might take a very long time)")
    skip_embeddings_and_memory: Optional[StrictBool] = Field(None, alias="skipEmbeddingsAndMemory", description="If set, skips creating embeddings and measuring memory (used in tests)")
    akida_edge_learning_config: Optional[AkidaEdgeLearningConfig] = Field(None, alias="akidaEdgeLearningConfig")
    custom_validation_metadata_key: Optional[StrictStr] = Field(None, alias="customValidationMetadataKey", description="If the 'custom validation split' experiment is enabled, this metadata key is used to prevent group data leakage between train and validation datasets.")
    show_advanced_training_settings: Optional[StrictBool] = Field(None, alias="showAdvancedTrainingSettings", description="Whether the 'Advanced training settings' UI element should be expanded.")
    show_augmentation_training_settings: Optional[StrictBool] = Field(None, alias="showAugmentationTrainingSettings", description="Whether the 'Augmentation training settings' UI element should be expanded.")
    custom_parameters: Optional[Dict[str, StrictStr]] = Field(None, alias="customParameters", description="Training parameters, this list depends on the list of parameters that the model exposes.")
    anomaly_capacity: Optional[AnomalyCapacity] = Field(None, alias="anomalyCapacity")
    last_shown_model_variant: Optional[KerasModelVariantEnum] = Field(None, alias="lastShownModelVariant")
    block_parameters: Optional[BlockParameters] = Field(None, alias="blockParameters")
    __properties = ["mode", "minimumConfidenceRating", "selectedModelType", "script", "visualLayers", "trainingCycles", "learningRate", "batchSize", "trainTestSplit", "autoClassWeights", "useLearnedOptimizer", "augmentationPolicyImage", "augmentationPolicySpectrogram", "profileInt8", "skipEmbeddingsAndMemory", "akidaEdgeLearningConfig", "customValidationMetadataKey", "showAdvancedTrainingSettings", "showAugmentationTrainingSettings", "customParameters", "anomalyCapacity", "lastShownModelVariant", "blockParameters"]

    @validator('mode')
    def mode_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('expert', 'visual'):
            raise ValueError("must validate the enum values ('expert', 'visual')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> SetKerasParameterRequest:
        """Create an instance of SetKerasParameterRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in visual_layers (list)
        _items = []
        if self.visual_layers:
            for _item in self.visual_layers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['visualLayers'] = _items
        # override the default output from pydantic by calling `to_dict()` of augmentation_policy_spectrogram
        if self.augmentation_policy_spectrogram:
            _dict['augmentationPolicySpectrogram'] = self.augmentation_policy_spectrogram.to_dict()
        # override the default output from pydantic by calling `to_dict()` of akida_edge_learning_config
        if self.akida_edge_learning_config:
            _dict['akidaEdgeLearningConfig'] = self.akida_edge_learning_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of block_parameters
        if self.block_parameters:
            _dict['blockParameters'] = self.block_parameters.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetKerasParameterRequest:
        """Create an instance of SetKerasParameterRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SetKerasParameterRequest.construct(**obj)

        _obj = SetKerasParameterRequest.construct(**{
            "mode": obj.get("mode"),
            "minimum_confidence_rating": obj.get("minimumConfidenceRating"),
            "selected_model_type": obj.get("selectedModelType"),
            "script": obj.get("script"),
            "visual_layers": [KerasVisualLayer.from_dict(_item) for _item in obj.get("visualLayers")] if obj.get("visualLayers") is not None else None,
            "training_cycles": obj.get("trainingCycles"),
            "learning_rate": obj.get("learningRate"),
            "batch_size": obj.get("batchSize"),
            "train_test_split": obj.get("trainTestSplit"),
            "auto_class_weights": obj.get("autoClassWeights"),
            "use_learned_optimizer": obj.get("useLearnedOptimizer"),
            "augmentation_policy_image": obj.get("augmentationPolicyImage"),
            "augmentation_policy_spectrogram": AugmentationPolicySpectrogram.from_dict(obj.get("augmentationPolicySpectrogram")) if obj.get("augmentationPolicySpectrogram") is not None else None,
            "profile_int8": obj.get("profileInt8"),
            "skip_embeddings_and_memory": obj.get("skipEmbeddingsAndMemory"),
            "akida_edge_learning_config": AkidaEdgeLearningConfig.from_dict(obj.get("akidaEdgeLearningConfig")) if obj.get("akidaEdgeLearningConfig") is not None else None,
            "custom_validation_metadata_key": obj.get("customValidationMetadataKey"),
            "show_advanced_training_settings": obj.get("showAdvancedTrainingSettings"),
            "show_augmentation_training_settings": obj.get("showAugmentationTrainingSettings"),
            "custom_parameters": obj.get("customParameters"),
            "anomaly_capacity": obj.get("anomalyCapacity"),
            "last_shown_model_variant": obj.get("lastShownModelVariant"),
            "block_parameters": BlockParameters.from_dict(obj.get("blockParameters")) if obj.get("blockParameters") is not None else None
        })
        return _obj

