# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator

class SetImpulseThresholdsResponseAllOf(BaseModel):
    had_model_testing_results: StrictBool = Field(..., alias="hadModelTestingResults", description="Whether there were model testing results available before calling this function.")
    regenerate_model_testing_status: StrictStr = Field(..., alias="regenerateModelTestingStatus", description="Altering thresholds invalidates model testing results. We try to regenerate the results where possible. You'll get either \"not_regenerated\" (e.g. no model testing results, or dataset does not support fast regeneration, like for object detection models); \"regenerated\" (regeneration successful); \"started_job\" (regenerate is possible, but requires a job, that was kicked off - e.g. for large test sets); \"requires_job\" (requires a job, but \"allowCreatingRegenerateModelTestingJobs\" was false - start a new job manually via regenerateModelTestingSummary). If a job was started then \"regenerateModelTestingResultsJobId\" is set. ")
    regenerate_model_testing_results_job_id: Optional[StrictInt] = Field(None, alias="regenerateModelTestingResultsJobId", description="If there previously were model testing results, and your dataset supports fast re-generation of model testing results (e.g. no object detection blocks), but your dataset is too big to re-generate results inline (e.g. >20K test set samples) - then a job is kicked off to regenerate the results. This field contains the job ID. ")
    __properties = ["hadModelTestingResults", "regenerateModelTestingStatus", "regenerateModelTestingResultsJobId"]

    @validator('regenerate_model_testing_status')
    def regenerate_model_testing_status_validate_enum(cls, v):
        if v not in ('not_regenerated', 'regenerated', 'started_job', 'requires_job'):
            raise ValueError("must validate the enum values ('not_regenerated', 'regenerated', 'started_job', 'requires_job')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> SetImpulseThresholdsResponseAllOf:
        """Create an instance of SetImpulseThresholdsResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetImpulseThresholdsResponseAllOf:
        """Create an instance of SetImpulseThresholdsResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SetImpulseThresholdsResponseAllOf.construct(**obj)

        _obj = SetImpulseThresholdsResponseAllOf.construct(**{
            "had_model_testing_results": obj.get("hadModelTestingResults"),
            "regenerate_model_testing_status": obj.get("regenerateModelTestingStatus"),
            "regenerate_model_testing_results_job_id": obj.get("regenerateModelTestingResultsJobId")
        })
        return _obj

