# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.sensor import Sensor

class RawSamplePayload(BaseModel):
    device_name: Optional[StrictStr] = Field(None, description="Unique identifier for this device. **Only** set this when the device has a globally unique identifier (e.g. MAC address).")
    device_type: StrictStr = Field(..., description="Device type, for example the exact model of the device. Should be the same for all similar devices.")
    sensors: List[Sensor] = Field(..., description="Array with sensor axes")
    values: List[List[float]] = Field(..., description="Array of sensor values. One array item per interval, and as many items in this array as there are sensor axes. This type is returned if there are multiple axes. ")
    crop_start: Optional[StrictInt] = Field(None, alias="cropStart", description="New start index of the cropped sample")
    crop_end: Optional[StrictInt] = Field(None, alias="cropEnd", description="New end index of the cropped sample")
    __properties = ["device_name", "device_type", "sensors", "values", "cropStart", "cropEnd"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> RawSamplePayload:
        """Create an instance of RawSamplePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in sensors (list)
        _items = []
        if self.sensors:
            for _item in self.sensors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sensors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RawSamplePayload:
        """Create an instance of RawSamplePayload from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RawSamplePayload.construct(**obj)

        _obj = RawSamplePayload.construct(**{
            "device_name": obj.get("device_name"),
            "device_type": obj.get("device_type"),
            "sensors": [Sensor.from_dict(_item) for _item in obj.get("sensors")] if obj.get("sensors") is not None else None,
            "values": obj.get("values"),
            "crop_start": obj.get("cropStart"),
            "crop_end": obj.get("cropEnd")
        })
        return _obj

