# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator

class ProjectInfoResponseAllOfAcquisitionSettings(BaseModel):
    interval_ms: float = Field(..., alias="intervalMs", description="Interval during the last acquisition, or the recommended interval based on the data set.")
    length_ms: StrictInt = Field(..., alias="lengthMs", description="Length of the last acquisition, or a recommended interval based on the data set.")
    sensor: Optional[StrictStr] = Field(None, description="Sensor that was used during the last acquisition.")
    label: Optional[StrictStr] = Field(None, description="Label that was used during the last acquisition.")
    segment_length: Optional[float] = Field(None, alias="segmentLength", description="Length of the last sample segment after segmenting a larger sample.")
    segment_shift: StrictBool = Field(..., alias="segmentShift", description="Whether to auto-shift segments")
    default_page_size: StrictInt = Field(..., alias="defaultPageSize", description="Default page size on data acquisition")
    view_type: StrictStr = Field(..., alias="viewType", description="Default view type on data acquisition")
    grid_column_count: StrictInt = Field(..., alias="gridColumnCount", description="Number of grid columns in non-detailed view")
    grid_column_count_detailed: StrictInt = Field(..., alias="gridColumnCountDetailed", description="Number of grid columns in detailed view")
    show_exact_sample_length: StrictBool = Field(..., alias="showExactSampleLength", description="If enabled, does not round sample length to hours/minutes/seconds, but always displays sample length in milliseconds. E.g. instead of 1m 32s, this'll say 92,142ms.")
    inline_edit_bounding_boxes: StrictBool = Field(..., alias="inlineEditBoundingBoxes", description="If enabled, allows editing bounding box labels directly from the acquisition UI.")
    __properties = ["intervalMs", "lengthMs", "sensor", "label", "segmentLength", "segmentShift", "defaultPageSize", "viewType", "gridColumnCount", "gridColumnCountDetailed", "showExactSampleLength", "inlineEditBoundingBoxes"]

    @validator('view_type')
    def view_type_validate_enum(cls, v):
        if v not in ('list', 'grid'):
            raise ValueError("must validate the enum values ('list', 'grid')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ProjectInfoResponseAllOfAcquisitionSettings:
        """Create an instance of ProjectInfoResponseAllOfAcquisitionSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectInfoResponseAllOfAcquisitionSettings:
        """Create an instance of ProjectInfoResponseAllOfAcquisitionSettings from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ProjectInfoResponseAllOfAcquisitionSettings.construct(**obj)

        _obj = ProjectInfoResponseAllOfAcquisitionSettings.construct(**{
            "interval_ms": obj.get("intervalMs"),
            "length_ms": obj.get("lengthMs"),
            "sensor": obj.get("sensor"),
            "label": obj.get("label"),
            "segment_length": obj.get("segmentLength"),
            "segment_shift": obj.get("segmentShift"),
            "default_page_size": obj.get("defaultPageSize"),
            "view_type": obj.get("viewType"),
            "grid_column_count": obj.get("gridColumnCount"),
            "grid_column_count_detailed": obj.get("gridColumnCountDetailed"),
            "show_exact_sample_length": obj.get("showExactSampleLength"),
            "inline_edit_bounding_boxes": obj.get("inlineEditBoundingBoxes")
        })
        return _obj

