# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.keras_custom_metric import KerasCustomMetric
from edgeimpulse_api.models.keras_model_variant_enum import KerasModelVariantEnum
from edgeimpulse_api.models.profile_model_info_memory import ProfileModelInfoMemory

class ProfileModelInfo(BaseModel):
    variant: KerasModelVariantEnum = ...
    device: StrictStr = ...
    tflite_file_size_bytes: StrictInt = Field(..., alias="tfliteFileSizeBytes")
    is_supported_on_mcu: StrictBool = Field(..., alias="isSupportedOnMcu")
    memory: Optional[ProfileModelInfoMemory] = None
    time_per_inference_ms: Optional[StrictInt] = Field(None, alias="timePerInferenceMs")
    mcu_support_error: Optional[StrictStr] = Field(None, alias="mcuSupportError")
    custom_metrics: List[KerasCustomMetric] = Field(..., alias="customMetrics", description="Custom, device-specific performance metrics")
    has_performance: StrictBool = Field(..., alias="hasPerformance", description="If false, then no metrics are available for this target")
    profiling_error: Optional[StrictStr] = Field(None, alias="profilingError", description="Specific error during profiling (e.g. model not supported)")
    __properties = ["variant", "device", "tfliteFileSizeBytes", "isSupportedOnMcu", "memory", "timePerInferenceMs", "mcuSupportError", "customMetrics", "hasPerformance", "profilingError"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ProfileModelInfo:
        """Create an instance of ProfileModelInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of memory
        if self.memory:
            _dict['memory'] = self.memory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in custom_metrics (list)
        _items = []
        if self.custom_metrics:
            for _item in self.custom_metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customMetrics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProfileModelInfo:
        """Create an instance of ProfileModelInfo from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ProfileModelInfo.construct(**obj)

        _obj = ProfileModelInfo.construct(**{
            "variant": obj.get("variant"),
            "device": obj.get("device"),
            "tflite_file_size_bytes": obj.get("tfliteFileSizeBytes"),
            "is_supported_on_mcu": obj.get("isSupportedOnMcu"),
            "memory": ProfileModelInfoMemory.from_dict(obj.get("memory")) if obj.get("memory") is not None else None,
            "time_per_inference_ms": obj.get("timePerInferenceMs"),
            "mcu_support_error": obj.get("mcuSupportError"),
            "custom_metrics": [KerasCustomMetric.from_dict(_item) for _item in obj.get("customMetrics")] if obj.get("customMetrics") is not None else None,
            "has_performance": obj.get("hasPerformance"),
            "profiling_error": obj.get("profilingError")
        })
        return _obj

