# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.organization_member_role import OrganizationMemberRole

class OrganizationUserAllOf(BaseModel):
    added: datetime = ...
    role: OrganizationMemberRole = ...
    project_count: StrictInt = Field(..., alias="projectCount")
    datasets: List[StrictStr] = ...
    last_access_to_organization: Optional[datetime] = Field(None, alias="lastAccessToOrganization", description="Date when the user last accessed the organization data.")
    last_organization_project_accessed: Optional[StrictInt] = Field(None, alias="lastOrganizationProjectAccessed", description="ID of the last project accessed by the user in the organization.")
    __properties = ["added", "role", "projectCount", "datasets", "lastAccessToOrganization", "lastOrganizationProjectAccessed"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationUserAllOf:
        """Create an instance of OrganizationUserAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationUserAllOf:
        """Create an instance of OrganizationUserAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationUserAllOf.construct(**obj)

        _obj = OrganizationUserAllOf.construct(**{
            "added": obj.get("added"),
            "role": obj.get("role"),
            "project_count": obj.get("projectCount"),
            "datasets": obj.get("datasets"),
            "last_access_to_organization": obj.get("lastAccessToOrganization"),
            "last_organization_project_accessed": obj.get("lastOrganizationProjectAccessed")
        })
        return _obj

