# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.organization_dataset_type_enum import OrganizationDatasetTypeEnum
from edgeimpulse_api.models.transformation_job_status_enum import TransformationJobStatusEnum

class OrganizationCreateProjectWithFilesAllOfFiles(BaseModel):
    id: StrictInt = ...
    file_name: StrictStr = Field(..., alias="fileName")
    bucket_path: StrictStr = Field(..., alias="bucketPath")
    transformation_job_id: Optional[StrictInt] = Field(None, alias="transformationJobId")
    transformation_job_status: TransformationJobStatusEnum = Field(..., alias="transformationJobStatus")
    link_to_data_item: StrictStr = Field(..., alias="linkToDataItem")
    length_string: StrictStr = Field(..., alias="lengthString", description="Only set after job was finished")
    source_dataset_type: OrganizationDatasetTypeEnum = Field(..., alias="sourceDatasetType")
    __properties = ["id", "fileName", "bucketPath", "transformationJobId", "transformationJobStatus", "linkToDataItem", "lengthString", "sourceDatasetType"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationCreateProjectWithFilesAllOfFiles:
        """Create an instance of OrganizationCreateProjectWithFilesAllOfFiles from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationCreateProjectWithFilesAllOfFiles:
        """Create an instance of OrganizationCreateProjectWithFilesAllOfFiles from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationCreateProjectWithFilesAllOfFiles.construct(**obj)

        _obj = OrganizationCreateProjectWithFilesAllOfFiles.construct(**{
            "id": obj.get("id"),
            "file_name": obj.get("fileName"),
            "bucket_path": obj.get("bucketPath"),
            "transformation_job_id": obj.get("transformationJobId"),
            "transformation_job_status": obj.get("transformationJobStatus"),
            "link_to_data_item": obj.get("linkToDataItem"),
            "length_string": obj.get("lengthString"),
            "source_dataset_type": obj.get("sourceDatasetType")
        })
        return _obj

