# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator
from edgeimpulse_api.models.organization_create_project_output_dataset_path_rule import OrganizationCreateProjectOutputDatasetPathRule
from edgeimpulse_api.models.organization_create_project_path_filter import OrganizationCreateProjectPathFilter
from edgeimpulse_api.models.project_visibility import ProjectVisibility

class OrganizationCreateProjectRequest(BaseModel):
    name: StrictStr = ...
    filter: Optional[StrictStr] = Field(None, description="Filter in SQL format, used for creating transformation jobs on clinical datasets")
    path_filters: Optional[List[OrganizationCreateProjectPathFilter]] = Field(None, alias="pathFilters", description="Set of paths to apply the transformation to, used for creating transformation jobs on default datasets. This option is experimental and may change in the future.")
    upload_type: Optional[StrictStr] = Field(None, alias="uploadType")
    project_id: Optional[StrictInt] = Field(None, alias="projectId")
    project_visibility: Optional[ProjectVisibility] = Field(None, alias="projectVisibility")
    new_project_name: Optional[StrictStr] = Field(None, alias="newProjectName")
    project_api_key: Optional[StrictStr] = Field(None, alias="projectApiKey")
    project_hmac_key: Optional[StrictStr] = Field(None, alias="projectHmacKey")
    transformation_block_id: Optional[StrictInt] = Field(None, alias="transformationBlockId")
    builtin_transformation_block: Optional[Dict[str, Any]] = Field(None, alias="builtinTransformationBlock")
    category: Optional[StrictStr] = None
    output_dataset_name: Optional[StrictStr] = Field(None, alias="outputDatasetName")
    output_dataset_bucket_id: Optional[StrictInt] = Field(None, alias="outputDatasetBucketId")
    output_dataset_bucket_path: Optional[StrictStr] = Field(None, alias="outputDatasetBucketPath", description="Path of new dataset within the bucket; used only when creating a new dataset.")
    output_path_in_dataset: Optional[StrictStr] = Field(None, alias="outputPathInDataset", description="Path within the selected dataset to upload transformed files into. Used only when uploading into a default (non-clinical) dataset.")
    output_dataset_path_rule: Optional[OrganizationCreateProjectOutputDatasetPathRule] = Field(None, alias="outputDatasetPathRule")
    label: Optional[StrictStr] = None
    email_recipient_uids: Optional[List[StrictInt]] = Field(None, alias="emailRecipientUids")
    transformation_parallel: Optional[StrictInt] = Field(None, alias="transformationParallel", description="Number of parallel jobs to start")
    extra_cli_arguments: Optional[StrictStr] = Field(None, alias="extraCliArguments", description="Optional extra arguments for this transformation block")
    parameters: Optional[Dict[str, StrictStr]] = Field(None, description="List of custom parameters for this transformation job (see the list of parameters that the block exposes).")
    __properties = ["name", "filter", "pathFilters", "uploadType", "projectId", "projectVisibility", "newProjectName", "projectApiKey", "projectHmacKey", "transformationBlockId", "builtinTransformationBlock", "category", "outputDatasetName", "outputDatasetBucketId", "outputDatasetBucketPath", "outputPathInDataset", "outputDatasetPathRule", "label", "emailRecipientUids", "transformationParallel", "extraCliArguments", "parameters"]

    @validator('upload_type')
    def upload_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('project', 'dataset'):
            raise ValueError("must validate the enum values ('project', 'dataset')")
        return v

    @validator('category')
    def category_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('training', 'testing', 'split'):
            raise ValueError("must validate the enum values ('training', 'testing', 'split')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationCreateProjectRequest:
        """Create an instance of OrganizationCreateProjectRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in path_filters (list)
        _items = []
        if self.path_filters:
            for _item in self.path_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['pathFilters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationCreateProjectRequest:
        """Create an instance of OrganizationCreateProjectRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationCreateProjectRequest.construct(**obj)

        _obj = OrganizationCreateProjectRequest.construct(**{
            "name": obj.get("name"),
            "filter": obj.get("filter"),
            "path_filters": [OrganizationCreateProjectPathFilter.from_dict(_item) for _item in obj.get("pathFilters")] if obj.get("pathFilters") is not None else None,
            "upload_type": obj.get("uploadType"),
            "project_id": obj.get("projectId"),
            "project_visibility": obj.get("projectVisibility"),
            "new_project_name": obj.get("newProjectName"),
            "project_api_key": obj.get("projectApiKey"),
            "project_hmac_key": obj.get("projectHmacKey"),
            "transformation_block_id": obj.get("transformationBlockId"),
            "builtin_transformation_block": obj.get("builtinTransformationBlock"),
            "category": obj.get("category"),
            "output_dataset_name": obj.get("outputDatasetName"),
            "output_dataset_bucket_id": obj.get("outputDatasetBucketId"),
            "output_dataset_bucket_path": obj.get("outputDatasetBucketPath"),
            "output_path_in_dataset": obj.get("outputPathInDataset"),
            "output_dataset_path_rule": obj.get("outputDatasetPathRule"),
            "label": obj.get("label"),
            "email_recipient_uids": obj.get("emailRecipientUids"),
            "transformation_parallel": obj.get("transformationParallel"),
            "extra_cli_arguments": obj.get("extraCliArguments"),
            "parameters": obj.get("parameters")
        })
        return _obj

