# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class OptimizeConfigSearchSpaceSource(BaseModel):
    type: StrictStr = Field(..., description="Search space source type")
    template_title: Optional[StrictStr] = Field(None, alias="templateTitle", description="Search space source template title")
    run_title: Optional[StrictStr] = Field(None, alias="runTitle", description="Search space source run title")
    impulse_title: Optional[StrictStr] = Field(None, alias="impulseTitle", description="Search space source impulse title")
    __properties = ["type", "templateTitle", "runTitle", "impulseTitle"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('template', 'run', 'impulse', 'custom'):
            raise ValueError("must validate the enum values ('template', 'run', 'impulse', 'custom')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OptimizeConfigSearchSpaceSource:
        """Create an instance of OptimizeConfigSearchSpaceSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OptimizeConfigSearchSpaceSource:
        """Create an instance of OptimizeConfigSearchSpaceSource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OptimizeConfigSearchSpaceSource.construct(**obj)

        _obj = OptimizeConfigSearchSpaceSource.construct(**{
            "type": obj.get("type"),
            "template_title": obj.get("templateTitle"),
            "run_title": obj.get("runTitle"),
            "impulse_title": obj.get("impulseTitle")
        })
        return _obj

