# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.oauth_grant_type import OauthGrantType

class OauthClientProperties(BaseModel):
    name: Optional[StrictStr] = Field(None, description="Name of the OAuth client")
    description: Optional[StrictStr] = Field(None, description="Optional description of the OAuth client")
    redirect_uris: Optional[List[StrictStr]] = Field(None, alias="redirectUris", description="List of allowed redirect URIs for this client")
    allowed_grant_types: Optional[List[OauthGrantType]] = Field(None, alias="allowedGrantTypes", description="List of allowed OAuth grant types for this client")
    scopes: Optional[List[StrictStr]] = Field(None, description="List of allowed scopes for this client")
    requires_consent: Optional[StrictBool] = Field(None, alias="requiresConsent", description="Indicates whether this OAuth client requires explicit user consent. Internal clients may not require consent.")
    logo_url: Optional[StrictStr] = Field(None, alias="logoUrl", description="URL of the OAuth client logo")
    owner_name: Optional[StrictStr] = Field(None, alias="ownerName", description="Name of the owner of the OAuth client")
    owner_url: Optional[StrictStr] = Field(None, alias="ownerUrl", description="URL of the owner of the OAuth client")
    __properties = ["name", "description", "redirectUris", "allowedGrantTypes", "scopes", "requiresConsent", "logoUrl", "ownerName", "ownerUrl"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OauthClientProperties:
        """Create an instance of OauthClientProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OauthClientProperties:
        """Create an instance of OauthClientProperties from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OauthClientProperties.construct(**obj)

        _obj = OauthClientProperties.construct(**{
            "name": obj.get("name"),
            "description": obj.get("description"),
            "redirect_uris": obj.get("redirectUris"),
            "allowed_grant_types": obj.get("allowedGrantTypes"),
            "scopes": obj.get("scopes"),
            "requires_consent": obj.get("requiresConsent"),
            "logo_url": obj.get("logoUrl"),
            "owner_name": obj.get("ownerName"),
            "owner_url": obj.get("ownerUrl")
        })
        return _obj

