# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic.v1 import BaseModel, Field, StrictInt
from edgeimpulse_api.models.neighbors_score import NeighborsScore

class NeighborsData(BaseModel):
    scores_and_neighbors: List[NeighborsScore] = Field(..., alias="scoresAndNeighbors", description="The label noise score and nearest neighbors for each window of data in the project that shows a potential label noise issue.")
    num_neighbors: StrictInt = Field(..., alias="numNeighbors", description="The number of neighbors used in the nearest neighbors algorithm.")
    __properties = ["scoresAndNeighbors", "numNeighbors"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> NeighborsData:
        """Create an instance of NeighborsData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in scores_and_neighbors (list)
        _items = []
        if self.scores_and_neighbors:
            for _item in self.scores_and_neighbors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['scoresAndNeighbors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NeighborsData:
        """Create an instance of NeighborsData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NeighborsData.construct(**obj)

        _obj = NeighborsData.construct(**{
            "scores_and_neighbors": [NeighborsScore.from_dict(_item) for _item in obj.get("scoresAndNeighbors")] if obj.get("scoresAndNeighbors") is not None else None,
            "num_neighbors": obj.get("numNeighbors")
        })
        return _obj

