# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.evaluate_result_value import EvaluateResultValue
from edgeimpulse_api.models.keras_model_type_enum import KerasModelTypeEnum
from edgeimpulse_api.models.learn_block_type import LearnBlockType

class ModelVariantStats(BaseModel):
    model_type: KerasModelTypeEnum = Field(..., alias="modelType")
    learn_block_id: StrictInt = Field(..., alias="learnBlockId", description="The learning block this model variant is from")
    learn_block_type: LearnBlockType = Field(..., alias="learnBlockType")
    confusion_matrix: Dict[str, Dict[str, Dict[str, Any]]] = Field(..., alias="confusionMatrix", description="A map from actual labels to predicted labels, where actual labels are listed in `trainingLabels` and possible predicted labels are listed in `classificationLabels`.")
    training_labels: List[StrictStr] = Field(..., alias="trainingLabels", description="The labels present in the model's training data. These are all present in the first dimension of the confusion matrix.")
    classification_labels: List[StrictStr] = Field(..., alias="classificationLabels", description="The possible labels resulting from classification. These may be present in the second dimension of the confusion matrix.")
    total_window_count: Optional[StrictInt] = Field(None, alias="totalWindowCount", description="The total number of windows that were evaluated")
    total_correct_window_count: Optional[EvaluateResultValue] = Field(None, alias="totalCorrectWindowCount")
    accuracy: EvaluateResultValue = ...
    __properties = ["modelType", "learnBlockId", "learnBlockType", "confusionMatrix", "trainingLabels", "classificationLabels", "totalWindowCount", "totalCorrectWindowCount", "accuracy"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ModelVariantStats:
        """Create an instance of ModelVariantStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in confusion_matrix (dict)
        _field_dict = {}
        if self.confusion_matrix:
            for _key in self.confusion_matrix:
                if self.confusion_matrix[_key]:
                    _field_dict[_key] = self.confusion_matrix[_key].to_dict()
            _dict['confusionMatrix'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of total_correct_window_count
        if self.total_correct_window_count:
            _dict['totalCorrectWindowCount'] = self.total_correct_window_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of accuracy
        if self.accuracy:
            _dict['accuracy'] = self.accuracy.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModelVariantStats:
        """Create an instance of ModelVariantStats from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ModelVariantStats.construct(**obj)

        _obj = ModelVariantStats.construct(**{
            "model_type": obj.get("modelType"),
            "learn_block_id": obj.get("learnBlockId"),
            "learn_block_type": obj.get("learnBlockType"),
            "confusion_matrix": { _k: { _sub_k: EvaluateResultValue.from_dict(_sub_v) for _sub_k, _sub_v in _v.items() } for _k, _v in obj.get("confusionMatrix", {}).items() },
            "training_labels": obj.get("trainingLabels"),
            "classification_labels": obj.get("classificationLabels"),
            "total_window_count": obj.get("totalWindowCount"),
            "total_correct_window_count": EvaluateResultValue.from_dict(obj.get("totalCorrectWindowCount")) if obj.get("totalCorrectWindowCount") is not None else None,
            "accuracy": EvaluateResultValue.from_dict(obj.get("accuracy")) if obj.get("accuracy") is not None else None
        })
        return _obj

