# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.block_display_category import BlockDisplayCategory
from edgeimpulse_api.models.block_type import BlockType
from edgeimpulse_api.models.public_project_tier_availability import PublicProjectTierAvailability

class LearnBlock(BaseModel):
    type: StrictStr = ...
    title: StrictStr = ...
    author: StrictStr = ...
    description: StrictStr = ...
    name: StrictStr = ...
    recommended: StrictBool = ...
    organization_model_id: Optional[StrictInt] = Field(None, alias="organizationModelId")
    public_project_tier_availability: Optional[PublicProjectTierAvailability] = Field(None, alias="publicProjectTierAvailability")
    is_public_enterprise_only: Optional[StrictBool] = Field(None, alias="isPublicEnterpriseOnly", description="Whether this block is publicly available to only enterprise users")
    block_type: BlockType = Field(..., alias="blockType")
    display_category: Optional[BlockDisplayCategory] = Field(None, alias="displayCategory")
    supported_targets: Optional[List[StrictStr]] = Field(None, alias="supportedTargets", description="List of target devices that support this learn block. If undefined this block works on all targets.")
    __properties = ["type", "title", "author", "description", "name", "recommended", "organizationModelId", "publicProjectTierAvailability", "isPublicEnterpriseOnly", "blockType", "displayCategory", "supportedTargets"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> LearnBlock:
        """Create an instance of LearnBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LearnBlock:
        """Create an instance of LearnBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return LearnBlock.construct(**obj)

        _obj = LearnBlock.construct(**{
            "type": obj.get("type"),
            "title": obj.get("title"),
            "author": obj.get("author"),
            "description": obj.get("description"),
            "name": obj.get("name"),
            "recommended": obj.get("recommended"),
            "organization_model_id": obj.get("organizationModelId"),
            "public_project_tier_availability": obj.get("publicProjectTierAvailability"),
            "is_public_enterprise_only": obj.get("isPublicEnterpriseOnly"),
            "block_type": obj.get("blockType"),
            "display_category": obj.get("displayCategory"),
            "supported_targets": obj.get("supportedTargets")
        })
        return _obj

