# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.enterprise_trial import EnterpriseTrial
from edgeimpulse_api.models.get_user_response_all_of_last_accepted_terms_of_service import GetUserResponseAllOfLastAcceptedTermsOfService
from edgeimpulse_api.models.get_user_response_all_of_last_accessed_projects import GetUserResponseAllOfLastAccessedProjects
from edgeimpulse_api.models.get_user_response_all_of_whitelabels import GetUserResponseAllOfWhitelabels
from edgeimpulse_api.models.permission import Permission
from edgeimpulse_api.models.project import Project
from edgeimpulse_api.models.staff_info import StaffInfo
from edgeimpulse_api.models.user_eula import UserEula
from edgeimpulse_api.models.user_experiment import UserExperiment
from edgeimpulse_api.models.user_organization import UserOrganization
from edgeimpulse_api.models.user_projects_sort_order import UserProjectsSortOrder
from edgeimpulse_api.models.user_tier_enum import UserTierEnum

class GetUserResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    id: StrictInt = ...
    username: StrictStr = ...
    name: StrictStr = ...
    email: StrictStr = ...
    photo: Optional[StrictStr] = None
    created: datetime = ...
    last_seen: Optional[datetime] = Field(None, alias="lastSeen")
    staff_info: StaffInfo = Field(..., alias="staffInfo")
    pending: StrictBool = ...
    job_title: Optional[StrictStr] = Field(None, alias="jobTitle")
    permissions: Optional[List[Permission]] = Field(None, description="List of permissions the user has")
    company_name: Optional[StrictStr] = Field(None, alias="companyName")
    activated: StrictBool = ...
    mfa_configured: StrictBool = Field(..., alias="mfaConfigured", description="Whether the user has configured multi-factor authentication")
    stripe_customer_id: Optional[StrictStr] = Field(None, alias="stripeCustomerId", description="Stripe customer ID, if any.")
    has_pending_payments: Optional[StrictBool] = Field(None, alias="hasPendingPayments", description="Whether the user has pending payments.")
    tier: UserTierEnum = ...
    idps: Optional[List[StrictStr]] = Field(None, description="List of identity providers (e.g. Google, GitHub) that the user has used to sign in with")
    organizations: List[UserOrganization] = Field(..., description="Organizations that the user is a member of. Only filled when requesting information about yourself.")
    projects: List[Project] = Field(..., description="List of all projects. This returns all projects for the user (regardless of whitelabel)")
    experiments: List[UserExperiment] = Field(..., description="Experiments the user has access to. Enabling experiments can only be done through a JWT token.")
    evaluation: Optional[StrictBool] = Field(None, description="Whether this is an ephemeral evaluation account.")
    ambassador: Optional[StrictBool] = Field(None, description="Whether this user is an ambassador.")
    whitelabels: Optional[List[GetUserResponseAllOfWhitelabels]] = Field(None, description="List of white labels the user is a member of")
    suspended: StrictBool = Field(..., description="Whether the user is suspended.")
    suspension_reason: Optional[StrictStr] = Field(None, alias="suspensionReason", description="Detailed explanation of why the user account was suspended. This could include violations of terms of service, suspicious activity, or administrative actions. ")
    notifications: List[StrictStr] = Field(..., description="List of notifications to show to the user.")
    subscription_cancellation_request_date: Optional[datetime] = Field(None, alias="subscriptionCancellationRequestDate", description="The date at which the user has requested to cancel their subscription.")
    subscription_downgrade_date: Optional[datetime] = Field(None, alias="subscriptionDowngradeDate", description="The date at which the user's subscription will be downgraded due to cancellation.")
    subscription_termination_date: Optional[datetime] = Field(None, alias="subscriptionTerminationDate", description="The date at which the user's subscription will be automatically terminated due to failed payments.")
    pay_as_you_go_subscription_period_start_date: Optional[datetime] = Field(None, alias="payAsYouGoSubscriptionPeriodStartDate", description="The start date of the current pay-as-you-go subscription period.")
    pay_as_you_go_subscription_period_end_date: Optional[datetime] = Field(None, alias="payAsYouGoSubscriptionPeriodEndDate", description="The end date of the current pay-as-you-go subscription period.")
    password_configured: StrictBool = Field(..., alias="passwordConfigured", description="Whether the user has configured a password")
    projects_sort_order: UserProjectsSortOrder = Field(..., alias="projectsSortOrder")
    active_enterprise_trial: Optional[EnterpriseTrial] = Field(None, alias="activeEnterpriseTrial")
    has_enterprise_features_access: StrictBool = Field(..., alias="hasEnterpriseFeaturesAccess", description="Whether the current user has access to enterprise features. This is true if the user is an enterprise user, or has an active enterprise trial.")
    timezone: Optional[StrictStr] = Field(None, description="Timezone for the user (or undefined if not specified).")
    last_accessed_projects: GetUserResponseAllOfLastAccessedProjects = Field(..., alias="lastAccessedProjects")
    private_personal_projects_used: StrictInt = Field(..., alias="privatePersonalProjectsUsed", description="Number of private projects created by the current user.")
    last_accepted_terms_of_service: Optional[GetUserResponseAllOfLastAcceptedTermsOfService] = Field(None, alias="lastAcceptedTermsOfService")
    eulas: List[UserEula] = Field(..., description="List of all Vendor End-User License Agreements that the user has accepted, or could accept.")
    __properties = ["success", "error", "id", "username", "name", "email", "photo", "created", "lastSeen", "staffInfo", "pending", "jobTitle", "permissions", "companyName", "activated", "mfaConfigured", "stripeCustomerId", "hasPendingPayments", "tier", "idps", "organizations", "projects", "experiments", "evaluation", "ambassador", "whitelabels", "suspended", "suspensionReason", "notifications", "subscriptionCancellationRequestDate", "subscriptionDowngradeDate", "subscriptionTerminationDate", "payAsYouGoSubscriptionPeriodStartDate", "payAsYouGoSubscriptionPeriodEndDate", "passwordConfigured", "projectsSortOrder", "activeEnterpriseTrial", "hasEnterpriseFeaturesAccess", "timezone", "lastAccessedProjects", "privatePersonalProjectsUsed", "lastAcceptedTermsOfService", "eulas"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> GetUserResponse:
        """Create an instance of GetUserResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of staff_info
        if self.staff_info:
            _dict['staffInfo'] = self.staff_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in organizations (list)
        _items = []
        if self.organizations:
            for _item in self.organizations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['organizations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item in self.projects:
                if _item:
                    _items.append(_item.to_dict())
            _dict['projects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in experiments (list)
        _items = []
        if self.experiments:
            for _item in self.experiments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['experiments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in whitelabels (list)
        _items = []
        if self.whitelabels:
            for _item in self.whitelabels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['whitelabels'] = _items
        # override the default output from pydantic by calling `to_dict()` of active_enterprise_trial
        if self.active_enterprise_trial:
            _dict['activeEnterpriseTrial'] = self.active_enterprise_trial.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_accessed_projects
        if self.last_accessed_projects:
            _dict['lastAccessedProjects'] = self.last_accessed_projects.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_accepted_terms_of_service
        if self.last_accepted_terms_of_service:
            _dict['lastAcceptedTermsOfService'] = self.last_accepted_terms_of_service.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in eulas (list)
        _items = []
        if self.eulas:
            for _item in self.eulas:
                if _item:
                    _items.append(_item.to_dict())
            _dict['eulas'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetUserResponse:
        """Create an instance of GetUserResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetUserResponse.construct(**obj)

        _obj = GetUserResponse.construct(**{
            "success": obj.get("success"),
            "error": obj.get("error"),
            "id": obj.get("id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "photo": obj.get("photo"),
            "created": obj.get("created"),
            "last_seen": obj.get("lastSeen"),
            "staff_info": StaffInfo.from_dict(obj.get("staffInfo")) if obj.get("staffInfo") is not None else None,
            "pending": obj.get("pending"),
            "job_title": obj.get("jobTitle"),
            "permissions": obj.get("permissions"),
            "company_name": obj.get("companyName"),
            "activated": obj.get("activated"),
            "mfa_configured": obj.get("mfaConfigured"),
            "stripe_customer_id": obj.get("stripeCustomerId"),
            "has_pending_payments": obj.get("hasPendingPayments"),
            "tier": obj.get("tier"),
            "idps": obj.get("idps"),
            "organizations": [UserOrganization.from_dict(_item) for _item in obj.get("organizations")] if obj.get("organizations") is not None else None,
            "projects": [Project.from_dict(_item) for _item in obj.get("projects")] if obj.get("projects") is not None else None,
            "experiments": [UserExperiment.from_dict(_item) for _item in obj.get("experiments")] if obj.get("experiments") is not None else None,
            "evaluation": obj.get("evaluation"),
            "ambassador": obj.get("ambassador"),
            "whitelabels": [GetUserResponseAllOfWhitelabels.from_dict(_item) for _item in obj.get("whitelabels")] if obj.get("whitelabels") is not None else None,
            "suspended": obj.get("suspended"),
            "suspension_reason": obj.get("suspensionReason"),
            "notifications": obj.get("notifications"),
            "subscription_cancellation_request_date": obj.get("subscriptionCancellationRequestDate"),
            "subscription_downgrade_date": obj.get("subscriptionDowngradeDate"),
            "subscription_termination_date": obj.get("subscriptionTerminationDate"),
            "pay_as_you_go_subscription_period_start_date": obj.get("payAsYouGoSubscriptionPeriodStartDate"),
            "pay_as_you_go_subscription_period_end_date": obj.get("payAsYouGoSubscriptionPeriodEndDate"),
            "password_configured": obj.get("passwordConfigured"),
            "projects_sort_order": obj.get("projectsSortOrder"),
            "active_enterprise_trial": EnterpriseTrial.from_dict(obj.get("activeEnterpriseTrial")) if obj.get("activeEnterpriseTrial") is not None else None,
            "has_enterprise_features_access": obj.get("hasEnterpriseFeaturesAccess"),
            "timezone": obj.get("timezone"),
            "last_accessed_projects": GetUserResponseAllOfLastAccessedProjects.from_dict(obj.get("lastAccessedProjects")) if obj.get("lastAccessedProjects") is not None else None,
            "private_personal_projects_used": obj.get("privatePersonalProjectsUsed"),
            "last_accepted_terms_of_service": GetUserResponseAllOfLastAcceptedTermsOfService.from_dict(obj.get("lastAcceptedTermsOfService")) if obj.get("lastAcceptedTermsOfService") is not None else None,
            "eulas": [UserEula.from_dict(_item) for _item in obj.get("eulas")] if obj.get("eulas") is not None else None
        })
        return _obj

