# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class GetOrganizationPortalResponseAllOf(BaseModel):
    id: StrictInt = Field(..., description="Portal ID for the new upload portal")
    name: StrictStr = Field(..., description="The name of the upload portal.")
    description: Optional[StrictStr] = Field(None, description="The purpose and description of the upload portal.")
    url: StrictStr = Field(..., description="The url postfix of the upload portal.")
    token: StrictStr = Field(..., description="The token used to validate access to the upload portal.")
    bucket_name: StrictStr = Field(..., alias="bucketName", description="The S3 bucket name to store the uploaded data.")
    bucket_id: Optional[StrictInt] = Field(None, alias="bucketId", description="S3 bucket ID. If missing, then this is using the Edge Impulse hosted bucket.")
    bucket_path: StrictStr = Field(..., alias="bucketPath", description="The S3 bucket path where uploaded data is stored.")
    bucket_url: Optional[StrictStr] = Field(None, alias="bucketUrl", description="The full S3 bucket path where uploaded data is stored.")
    storage_provider: Optional[StrictStr] = Field(None, alias="storageProvider", description="The storage provider type (s3, azure, google, other).")
    __properties = ["id", "name", "description", "url", "token", "bucketName", "bucketId", "bucketPath", "bucketUrl", "storageProvider"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> GetOrganizationPortalResponseAllOf:
        """Create an instance of GetOrganizationPortalResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetOrganizationPortalResponseAllOf:
        """Create an instance of GetOrganizationPortalResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetOrganizationPortalResponseAllOf.construct(**obj)

        _obj = GetOrganizationPortalResponseAllOf.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "token": obj.get("token"),
            "bucket_name": obj.get("bucketName"),
            "bucket_id": obj.get("bucketId"),
            "bucket_path": obj.get("bucketPath"),
            "bucket_url": obj.get("bucketUrl"),
            "storage_provider": obj.get("storageProvider")
        })
        return _obj

