# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class ExportInferenceHistoryDataRequest(BaseModel):
    deployment_id: float = Field(..., alias="deploymentId")
    start_timestamp: float = Field(..., alias="startTimestamp")
    end_timestamp: float = Field(..., alias="endTimestamp")
    device_filters: Optional[StrictStr] = Field(None, alias="deviceFilters", description="Optional list of devices to filter by, given as a JSON string")
    format: StrictStr = Field(..., description="Data export format")
    __properties = ["deploymentId", "startTimestamp", "endTimestamp", "deviceFilters", "format"]

    @validator('format')
    def format_validate_enum(cls, v):
        if v not in ('row-per-summary', 'row-per-value'):
            raise ValueError("must validate the enum values ('row-per-summary', 'row-per-value')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ExportInferenceHistoryDataRequest:
        """Create an instance of ExportInferenceHistoryDataRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportInferenceHistoryDataRequest:
        """Create an instance of ExportInferenceHistoryDataRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExportInferenceHistoryDataRequest.construct(**obj)

        _obj = ExportInferenceHistoryDataRequest.construct(**{
            "deployment_id": obj.get("deploymentId"),
            "start_timestamp": obj.get("startTimestamp"),
            "end_timestamp": obj.get("endTimestamp"),
            "device_filters": obj.get("deviceFilters"),
            "format": obj.get("format")
        })
        return _obj

