# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr

class DSPGroupItemSelectOptionsInner(BaseModel):
    value: Optional[StrictStr] = Field(None, description="What is the string that will be set if this option is selected?")
    selected: Optional[StrictBool] = None
    option_label: Optional[StrictStr] = Field(None, alias="optionLabel", description="What is the label that will be shown to the user for this option?")
    priority: Optional[float] = Field(None, description="The following options are optional.  See Learn Block Auto Config in Notion. Higher priority will get chosen based on limits below.")
    rom_estimate: Optional[float] = Field(None, alias="romEstimate", description="Estimated ROM footprint for this choice.  Will be tested against ROM budget in Studio.")
    needs_ops: Optional[List[StrictStr]] = Field(None, alias="needsOps")
    needs_features: Optional[List[StrictStr]] = Field(None, alias="needsFeatures")
    __properties = ["value", "selected", "optionLabel", "priority", "romEstimate", "needsOps", "needsFeatures"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> DSPGroupItemSelectOptionsInner:
        """Create an instance of DSPGroupItemSelectOptionsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DSPGroupItemSelectOptionsInner:
        """Create an instance of DSPGroupItemSelectOptionsInner from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DSPGroupItemSelectOptionsInner.construct(**obj)

        _obj = DSPGroupItemSelectOptionsInner.construct(**{
            "value": obj.get("value"),
            "selected": obj.get("selected"),
            "option_label": obj.get("optionLabel"),
            "priority": obj.get("priority"),
            "rom_estimate": obj.get("romEstimate"),
            "needs_ops": obj.get("needsOps"),
            "needs_features": obj.get("needsFeatures")
        })
        return _obj

