# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr

class CreateProTierUserRequest(BaseModel):
    name: StrictStr = Field(..., description="Your name")
    username: StrictStr = Field(..., description="Username, minimum 4 and maximum 30 characters. May contain alphanumeric characters, hyphens, underscores and dots. Validated according to `^(?=.{4,30}$)(?![_.])(?!.*[_.]{2})[a-zA-Z0-9._-]+(?<![_.])$`.")
    email: StrictStr = Field(..., description="E-mail address. Will need to be validated before the account will become active.")
    password: Optional[StrictStr] = Field(None, description="Password, minimum length 8 characters.")
    project_name: Optional[StrictStr] = Field(None, alias="projectName", description="A project will automatically be created. Sets the name of the first project. If not set, this will be derived from the username.")
    privacy_policy: StrictBool = Field(..., alias="privacyPolicy", description="Whether the user accepted the privacy policy")
    activation_token: Optional[StrictStr] = Field(None, alias="activationToken", description="Activation token for users created via SSO")
    identity_provider: Optional[StrictStr] = Field(None, alias="identityProvider", description="Unique identifier of the identity provider asserting the identity of this user")
    job_title: Optional[StrictStr] = Field(None, alias="jobTitle", description="Job title of the user. Optional field")
    session_id: Optional[StrictStr] = Field(None, alias="sessionId", description="Session ID. Optional field")
    company_name: Optional[StrictStr] = Field(None, alias="companyName", description="ACME Inc.")
    utm_params: Optional[List[Dict[str, Any]]] = Field(None, alias="utmParams", description="List of UTM parameters.")
    ignore_email_validation: Optional[StrictBool] = Field(None, alias="ignoreEmailValidation", description="If true, allows signup to proceed despite a potentially invalid email. Note that this will enforce email verification post-signup")
    turnstile_response: StrictStr = Field(..., alias="turnstileResponse", description="CloudFlare Turnstile response token")
    redirect_url_origin: Optional[StrictStr] = Field(None, alias="redirectUrlOrigin", description="Origin of the redirect URL returned as result of creating the professional user.")
    redirect_url_query_params: Optional[StrictStr] = Field(None, alias="redirectUrlQueryParams", description="Query parameters to be appended to the redirect URL returned as result of creating the professional user.")
    __properties = ["name", "username", "email", "password", "projectName", "privacyPolicy", "activationToken", "identityProvider", "jobTitle", "sessionId", "companyName", "utmParams", "ignoreEmailValidation", "turnstileResponse", "redirectUrlOrigin", "redirectUrlQueryParams"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> CreateProTierUserRequest:
        """Create an instance of CreateProTierUserRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateProTierUserRequest:
        """Create an instance of CreateProTierUserRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateProTierUserRequest.construct(**obj)

        _obj = CreateProTierUserRequest.construct(**{
            "name": obj.get("name"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "password": obj.get("password"),
            "project_name": obj.get("projectName"),
            "privacy_policy": obj.get("privacyPolicy"),
            "activation_token": obj.get("activationToken"),
            "identity_provider": obj.get("identityProvider"),
            "job_title": obj.get("jobTitle"),
            "session_id": obj.get("sessionId"),
            "company_name": obj.get("companyName"),
            "utm_params": obj.get("utmParams"),
            "ignore_email_validation": obj.get("ignoreEmailValidation"),
            "turnstile_response": obj.get("turnstileResponse"),
            "redirect_url_origin": obj.get("redirectUrlOrigin"),
            "redirect_url_query_params": obj.get("redirectUrlQueryParams")
        })
        return _obj

