# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator
from edgeimpulse_api.models.classify_job_response_all_of_accuracy import ClassifyJobResponseAllOfAccuracy
from edgeimpulse_api.models.classify_job_response_all_of_additional_metrics_by_learn_block import ClassifyJobResponseAllOfAdditionalMetricsByLearnBlock
from edgeimpulse_api.models.keras_model_variant_enum import KerasModelVariantEnum
from edgeimpulse_api.models.model_prediction import ModelPrediction
from edgeimpulse_api.models.model_result import ModelResult

class ClassifyJobResponseAllOf(BaseModel):
    result: List[ModelResult] = ...
    predictions: List[ModelPrediction] = ...
    accuracy: ClassifyJobResponseAllOfAccuracy = ...
    additional_metrics_by_learn_block: List[ClassifyJobResponseAllOfAdditionalMetricsByLearnBlock] = Field(..., alias="additionalMetricsByLearnBlock")
    available_variants: List[KerasModelVariantEnum] = Field(..., alias="availableVariants", description="List of all model variants for which classification results exist")
    no_results_because_thresholds_changed: Optional[StrictStr] = Field(None, alias="noResultsBecauseThresholdsChanged", description="If set to true, there are currently no results because thresholds were changed (e.g. on live classification); and what action you can run to get new results the quickest. If the value is \"can_regenerate_model_summary\" you can run 'regenerateModelTestingSummary'. If the value is \"should_rerun_full_job\", you need to run 'startClassifyJob' or 'startEvaluateJob'. ")
    __properties = ["result", "predictions", "accuracy", "additionalMetricsByLearnBlock", "availableVariants", "noResultsBecauseThresholdsChanged"]

    @validator('no_results_because_thresholds_changed')
    def no_results_because_thresholds_changed_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('can_regenerate_model_summary', 'should_rerun_full_job'):
            raise ValueError("must validate the enum values ('can_regenerate_model_summary', 'should_rerun_full_job')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ClassifyJobResponseAllOf:
        """Create an instance of ClassifyJobResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in result (list)
        _items = []
        if self.result:
            for _item in self.result:
                if _item:
                    _items.append(_item.to_dict())
            _dict['result'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in predictions (list)
        _items = []
        if self.predictions:
            for _item in self.predictions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['predictions'] = _items
        # override the default output from pydantic by calling `to_dict()` of accuracy
        if self.accuracy:
            _dict['accuracy'] = self.accuracy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in additional_metrics_by_learn_block (list)
        _items = []
        if self.additional_metrics_by_learn_block:
            for _item in self.additional_metrics_by_learn_block:
                if _item:
                    _items.append(_item.to_dict())
            _dict['additionalMetricsByLearnBlock'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClassifyJobResponseAllOf:
        """Create an instance of ClassifyJobResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ClassifyJobResponseAllOf.construct(**obj)

        _obj = ClassifyJobResponseAllOf.construct(**{
            "result": [ModelResult.from_dict(_item) for _item in obj.get("result")] if obj.get("result") is not None else None,
            "predictions": [ModelPrediction.from_dict(_item) for _item in obj.get("predictions")] if obj.get("predictions") is not None else None,
            "accuracy": ClassifyJobResponseAllOfAccuracy.from_dict(obj.get("accuracy")) if obj.get("accuracy") is not None else None,
            "additional_metrics_by_learn_block": [ClassifyJobResponseAllOfAdditionalMetricsByLearnBlock.from_dict(_item) for _item in obj.get("additionalMetricsByLearnBlock")] if obj.get("additionalMetricsByLearnBlock") is not None else None,
            "available_variants": obj.get("availableVariants"),
            "no_results_because_thresholds_changed": obj.get("noResultsBecauseThresholdsChanged")
        })
        return _obj

