# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, validator

class AugmentationPolicySpectrogram(BaseModel):
    enabled: StrictBool = Field(..., description="True if spectrogram augmentation is enabled. Other properties will be ignored if this is false.")
    warping: Optional[StrictBool] = Field(None, description="True if warping along the time axis is enabled.")
    freq_masking: Optional[StrictStr] = Field(None, alias="freqMasking", description="The amount of frequency masking to apply.")
    time_masking: Optional[StrictStr] = Field(None, alias="timeMasking", description="The amount of time masking to apply.")
    gaussian_noise: Optional[StrictStr] = Field(None, alias="gaussianNoise", description="The amount of Gaussian noise to add.")
    __properties = ["enabled", "warping", "freqMasking", "timeMasking", "gaussianNoise"]

    @validator('freq_masking')
    def freq_masking_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('none', 'low', 'high'):
            raise ValueError("must validate the enum values ('none', 'low', 'high')")
        return v

    @validator('time_masking')
    def time_masking_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('none', 'low', 'high'):
            raise ValueError("must validate the enum values ('none', 'low', 'high')")
        return v

    @validator('gaussian_noise')
    def gaussian_noise_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('none', 'low', 'high'):
            raise ValueError("must validate the enum values ('none', 'low', 'high')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AugmentationPolicySpectrogram:
        """Create an instance of AugmentationPolicySpectrogram from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AugmentationPolicySpectrogram:
        """Create an instance of AugmentationPolicySpectrogram from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AugmentationPolicySpectrogram.construct(**obj)

        _obj = AugmentationPolicySpectrogram.construct(**{
            "enabled": obj.get("enabled"),
            "warping": obj.get("warping"),
            "freq_masking": obj.get("freqMasking"),
            "time_masking": obj.get("timeMasking"),
            "gaussian_noise": obj.get("gaussianNoise")
        })
        return _obj

