# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator

class AdminStartEnterpriseTrialRequest(BaseModel):
    email: Optional[StrictStr] = Field(None, description="Email of the user requesting the trial. If this email is different to the one stored for the user requesting the trial, it will be used to replace the existing one.")
    name: Optional[StrictStr] = Field(None, description="Name of the user requesting the trial. If this name is different to the one stored for the user requesting the trial, it will be used to replace the existing one.")
    organization_name: Optional[StrictStr] = Field(None, alias="organizationName", description="Name of the trial organization. All enterprise features are tied to an organization. This organization will be deleted after the trial ends. If no organization name is provided, the user's name will be used.")
    expiration_date: Optional[datetime] = Field(None, alias="expirationDate", description="Expiration date of the trial. The trial will be set as expired after this date. There will be a grace period of 30 days after a trial expires before fully deleting the trial organization. This field is ignored if the trial is requested by a non-admin user, defaulting to 14 days trial.")
    notes: Optional[StrictStr] = Field(None, description="Notes about the trial. Free form text. This field is ignored if the trial is requested by a non-admin user.")
    use_case: Optional[StrictStr] = Field(None, alias="useCase", description="Use case of the trial.")
    user_has_ml_models_in_production: Optional[StrictStr] = Field(None, alias="userHasMLModelsInProduction", description="Whether the user has ML models in production.")
    company_name: Optional[StrictStr] = Field(None, alias="companyName", description="Name of the company requesting the trial.")
    company_size: Optional[StrictStr] = Field(None, alias="companySize", description="Size of the company requesting the trial. This is a range of number of employees.")
    country: Optional[StrictStr] = Field(None, description="Country of the company requesting the trial.")
    state_or_province: Optional[StrictStr] = Field(None, alias="stateOrProvince", description="State or province of the company requesting the trial.")
    redirect_url_origin: Optional[StrictStr] = Field(None, alias="redirectUrlOrigin", description="Origin of the redirect URL returned as result of creating the trial user.")
    redirect_url_query_params: Optional[StrictStr] = Field(None, alias="redirectUrlQueryParams", description="Query parameters to be appended to the redirect URL returned as result of creating the trial user.")
    user_id: StrictInt = Field(..., alias="userId", description="ID of the user requesting the trial.")
    __properties = ["email", "name", "organizationName", "expirationDate", "notes", "useCase", "userHasMLModelsInProduction", "companyName", "companySize", "country", "stateOrProvince", "redirectUrlOrigin", "redirectUrlQueryParams", "userId"]

    @validator('user_has_ml_models_in_production')
    def user_has_ml_models_in_production_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('yes', 'no', 'no, but we will soon'):
            raise ValueError("must validate the enum values ('yes', 'no', 'no, but we will soon')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AdminStartEnterpriseTrialRequest:
        """Create an instance of AdminStartEnterpriseTrialRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminStartEnterpriseTrialRequest:
        """Create an instance of AdminStartEnterpriseTrialRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminStartEnterpriseTrialRequest.construct(**obj)

        _obj = AdminStartEnterpriseTrialRequest.construct(**{
            "email": obj.get("email"),
            "name": obj.get("name"),
            "organization_name": obj.get("organizationName"),
            "expiration_date": obj.get("expirationDate"),
            "notes": obj.get("notes"),
            "use_case": obj.get("useCase"),
            "user_has_ml_models_in_production": obj.get("userHasMLModelsInProduction"),
            "company_name": obj.get("companyName"),
            "company_size": obj.get("companySize"),
            "country": obj.get("country"),
            "state_or_province": obj.get("stateOrProvince"),
            "redirect_url_origin": obj.get("redirectUrlOrigin"),
            "redirect_url_query_params": obj.get("redirectUrlQueryParams"),
            "user_id": obj.get("userId")
        })
        return _obj

