---
sidebar_position: 3
title: 3) Incident management
---

Boards need to be prepared to detect and respond to incidents in order to prevent the attacker from inflicting further damage. Handling an incident effectively whilst in the media spotlight is not easy but it will go a long way to reducing the overall impact on an organisation’s reputation.

An organisation’s incident management framework must ensure that everyone has a clear understanding of their role, especially board members who are likely be representing the organisation in the media. Boards also need to make clear who it is willing to devolve authority to when there is an incident.

Cyber attacks can take many different forms. They include attempts to gain unauthorised access to a system, malicious disruption, or a denial of service.

Pre-emptive actions and measures that boards put in place can have significant impact at the time of an attack. For example, backing up data or network segmentation can go a long way to limiting the damage of a cyber incident.

First things first, however. How do boards know when an incident has occurred? In most cases, it will be a notification from the security team, and it is at that point that boards will need to follow the incident management framework they have put in place, which should include:

- Identify the key contacts required at the time of an incident (incident response team, senior management, security, IT, legal, PR, HR, insurance providers).
- Establish escalation routes and defined processes for critical decisions.
- Clear allocation of responsibility.
- Guidance on regulatory requirements.
- Contingency measures for critical functions.
- Evaluation and learning.

Boards can provide valuable challenge and input to the development of an incident plan by asking questions and engaging with their security teams.
 
- What are the triggers that will inform us that an incident has happened? How do we then share that information within the organisation? 
- What monitoring is in place around critical assets, the organisation’s crown jewels?
- What reporting mechanisms are there in place for staff to report any suspicious activity? 
- Are the thresholds for alerts set to the right level, i.e., low enough to give warning of potential incidents and high enough that the team dealing with them are not overloaded with irrelevant information?
- Has the board explicitly conveyed the threshold for when it wants to be informed of an incident?
