---
sidebar_position: 2
title: 2) Building a cybersecure organisation.
---

Unfortunately, cyber crime is not going away. In 2022 alone, ransomware attacks increased by 1000%. Leaders wanting to build cybersecure organisations should understand that it starts with them. Leaders are required to become visible advocates of an organisation’s cyber strategy. While leaders will want to ensure their organisation is as prepared as they can be, they should also assume will be attacked. Not if, but when. The issue they need to focus on is how their organisation will react when it happens.

One of the first decisions leaders need to take is to identify their crown jewels: the assets or systems without which, the business essentially cannot function. Only the board can identify them. Security teams can help protect them, but they should not be the ones defining them.

Boards should be asking questions such as the following from their security teams in order to assess risks and mitigation strategies:

- As an organisation, how do we ensure that our software and devices are up to date? 
- How do we defend against phishing attacks? 
- What authentication methods are used to control access to systems and data?

The answers the board get will be technical but nevertheless, board members will be able to assess if solutions and policies are in place. And they will be able to evaluate their effectiveness as and when cyber incidents occur.

Security teams should talk about filtering or blocking emails; how they stop attackers ‘spoofing’ emails; and how staff are helped to identify and report suspicious emails. 

On accounts and privileges security teams should adopt a 'least privilege' approach. And they should define processes to identify and fix vulnerabilities while creating an ‘end of life plan' for devices and software that are no longer supported. Network architecture should minimize the harm that an attack can cause.
 
And board members should lead by example, adopting sensible passwords and two factor authentication (2FA) wherever possible.

Key issues board members will want to add to the cybersecurity agenda include:

- Zero-trust architecture.
- Supply chain cyber risk: a good understanding of suppliers and confidence in their cyber readiness; define what data and networks they have access to; limit information exchanged with third parties to the minimum necessary. 
- Capability: hiring a security team and a CISO.
- Cybersecurity defences: from awareness/training to technology.
- What constitutes good cyber hygiene:
  - Network security: defend network perimeter, filter out malicious content.
  - User education and awareness: produce policies, deliver training.
  - Malware prevention: anti-malware defences.
  - Secure configuration: apply security patches, create a system inventory.
  - Manage user privileges: limit privileges and control access to activity.
  - Incident management: incident response and disaster recovery capability.
  - Monitoring: continuously monitor all systems and networks.
  - Mobile working: mobile working policy.

Finally, the board should influence the awareness training and overall culture so that staff are encouraged to speak up and report any concerns or suspicious activity, and feel empowered to do so.
