---
sidebar_position: 1
title: 1) Cybersecurity in the boardroom
---

Too many boards see cybersecurity as an IT concern, not a board-level responsibility. This leads to a lack of understanding between boards and their security teams, as board members feel that technical staff are unable to explain key issues in the context of the strategic aims of the organisation. In turn, security teams think that the board does not have the required knowledge to understand them. Ultimately, boards accept that they need to improve their cybersecurity governance but lack the required confidence to do so. 

Part of the problem is this misguided view that cybersecurity is a technology or an IT conversation. It’s not. It’s a risk management conversation. This means boards must:

- Obtain the information they need to make well informed decisions. 
- Use this information to understand and prioritise risks. 
- Take steps to mitigate those risks.

To do this, boards need a strong relationship with their security teams, who can provide the necessary insights that lead to informed decisions.

Once boards have established that cybersecurity is to be part and parcel of their organisations’ risk management and decision making, it follows that cybersecurity will feature across:

- Operational risk: e.g., email, software.
- Legal risk: e.g., data protection; regulatory requirements.
- Financial risk: e.g., fraud; ransomware attacks.

As with other risks an organisation deals with, boards will need to put a risk management framework in place that addresses:

- How risks are escalated. 
- Frequency with which risks are reviewed.
- Who owns which risks. 

Risks can only be mitigated if they are defined properly, and it is therefore crucial that boards commission an audit of their digital estates. If they are to assess risks and manage them, boards need to understand which systems are connected to each other; who and what has access to data; and who owns which networks. 

In many cases, incidents arise because of vulnerabilities in legacy systems. Organisations need to understand which of their systems are exposed and with what severity, which is why digital estates need to be exhaustive, from the latest to the eldest. Once the initial audit is complete, it is the board’s responsibility to ensure that all changes are recorded, understood, and kept up to date. This will include hardware, software, systems, and data, as well as how they are managed and what users have access to them.

Once this exercise is complete, boards can turn their attention, in partnership with their security teams, to identifying the overall threat landscape, which includes the threat actors, the groups or individuals that could carry out a cyber attack. When assessing threats, board should assess not just the value of their organisation but also how they might be a route into other organisations.
