## Platforms (LLMs) 

The Cyber Boardroom supports multiple LLM's platforms, providers and models


### Groq (Free)
Groq is a platform that offers free access to various AI models. Here are the models available on Groq:

| Provider   | Model Name         | Identifier                  |
|------------|--------------------|-----------------------------|
| Meta       | LLaMA3 8b          | llama3-8b-8192              |
| Meta       | LLaMA3 70b         | llama3-70b-8192             |
| Mistral    | Mixtral 8x7b       | mixtral-8x7b-32768          |
| Google     | Gemma 7b           | gemma-7b-it                 |

---  

### Open Router (Free)
Open Router provides free access to a wide range of models from different providers. Here are the models available on Open Router:

| Provider       | Model Name         | Identifier                             |
|----------------|--------------------|----------------------------------------|
| Google         | Gemma 7b           | google/gemma-7b-it:free                |
| Google         | Gemma 9b           | google/gemma-2-9b-it:free              |
| Meta           | LLaMA3 8b          | meta-llama/llama-3-8b-instruct:free    |
| Microsoft      | Phi-3 Medium 128K  | microsoft/phi-3-medium-128k-instruct:free |
| Microsoft      | Phi-3 Mini 128K    | microsoft/phi-3-mini-128k-instruct:free |
| Nous Research  | Capybara 7b        | nousresearch/nous-capybara-7b:free     |
| Open Chat      | Openchat 7b        | openchat/openchat-7b:free              |
| Gryphe         | Mythomist 7b       | gryphe/mythomist-7b:free               |
| Wild 7B        | Toppy M 7b         | undi95/toppy-m-7b:free                 |
| Hugging Face   | Zephyr 7b          | huggingfaceh4/zephyr-7b-beta:free      |
| Mistral        | Mistral 7b Instruct| mistralai/mistral-7b-instruct:free     |


---  


###  Open Router (Paid)
Open Router offers paid access to a selection of high-performance models. Here are the models available on Open Router:

| Provider       | Model Name         | Identifier                             |
|----------------|--------------------|----------------------------------------|
| Qwen           | Qwen 2 72B         | qwen/qwen-2-72b-instruct               |
| Anthropic      | Claude Instant v1  | anthropic/claude-instant-1:beta        |
| Anthropic      | Claude 3.5 Sonnet  | anthropic/claude-3.5-sonnet            |
| Gryphe         | MythoMax 13b       | gryphe/mythomax-l2-13b                 |
| Meta           | Llama3 70b Instruct| meta-llama/llama-3-70b-instruct        |
| Nous Research  | Hermes 2 7b        | nousresearch/hermes-2-theta-llama-3-8b |
| Microsoft      | WizardLM-2 8x22b   | microsoft/wizardlm-2-8x22b             |
| Nvidia         | Nemotron-4 340b    | nvidia/nemotron-4-340b-instruct        |
| Google         | Gemini Flash 1.5   | google/gemini-flash-1.5                |
| Google         | Gemma 9b           | google/gemma-2-9b-it                   |
| Sao10K         | Llama3 Euryale 70b | sao10k/l3-euryale-70b                  |

---  

###  Ollama (Local)
Ollama allows local access to a variety of models from top providers. Here are the models available on Ollama:

| Provider   | Model Name         | Identifier                  |
|------------|--------------------|-----------------------------|
| Meta       | LLaMA3 8b          | llama3                      |
| Microsoft  | Phi 3b (Mini)      | phi3                        |
| Google     | Gemma 7b           | gemma                       |

#### OpenAI (Paid)
OpenAI provides access to advanced AI models for various applications. Here are the models available on OpenAI:

---  


| Provider | Model Name         | Identifier        |
|----------|--------------------|-------------------|
| OpenAI   | GPT 4o             | gpt-4o            |
| OpenAI   | GPT 4 Turbo        | gpt-4-turbo       |
| OpenAI   | GPT 3.5 Turbo      | gpt-3.5-turbo     |

### Together AI (Paid)
Together AI offers access to high-end models for complex tasks. Here are the models available on Together AI:

| Provider       | Model Name         | Identifier                                |
|----------------|--------------------|-------------------------------------------|
| Meta           | LLaMA3 70b HF      | meta-llama/Llama-3-70b-chat-hf            |
| Qwen           | Qwen2 72B          | Qwen/Qwen2-72B-Instruct                   |
| Qwen           | Qwen1.5 110B       | Qwen/Qwen1.5-110B-Chat                    |
| Mistral AI     | Mistral-7B         | mistralai/Mistral-7B-Instruct-v0.3        |
| Deepseek AI    | Deepseek LLM 67b   | deepseek-ai/deepseek-llm-67b-chat         |
| Snowflake      | Arctic Instruct    | Snowflake/snowflake-arctic-instruct       |
| Databricks     | DBRX Instruct      | databricks/dbrx-instruct                  |
