## Documentation 

Welcome to docs section of The Cyber Boardroom - Community Edition

- See [LinkedIn posts about The Cyber Boardroom](docs/news/blog-posts)

### Gen AI models

Explore the range of Generative AI models supported by The Cyber Boardroom. This section provides information on various platforms, providers, and models that are integrated into our system, enabling powerful AI-driven capabilities for users.

 - [Currently supported GenAI](docs/platforms/index) Platforms, Providers and Models

### Good demos

Discover effective demonstrations that showcase the capabilities of The Cyber Boardroom. This section includes personas and platforms, offering practical examples of how our tools can be utilized in different scenarios.

#### Personas

Learn about the different personas available within The Cyber Boardroom, such as the CFO persona. These personas represent various user roles and provide tailored experiences to enhance decision-making and strategy development.

- [CFO](docs/personas/cfo/index)

#### Platforms

Explore the diverse platforms supported by The Cyber Boardroom, including Open Router and Together AI. Each platform offers multiple large language models (LLMs) and board personas, providing robust AI functionalities for various applications.

- [Groq](docs/platforms/groq/index) 
    - [Speak in 6x languages](docs/platforms/groq/speak-in-6-languages)
    - [Talk with 3x Board Personas](docs/platforms/groq/talk-with-3x-board-personas)
- [Together AI](docs/platforms/together-ai/index)
    - [Multiple LLMs](docs/platforms/together-ai/query-multiple-lllms)

#### MVPs

Discover our Minimum Viable Prototypes (MVPs), featuring three LLMs configurations. These MVPs demonstrate the core capabilities of The Cyber Boardroom and provide a foundation for further development and customization.

  - [Three LLMs](chat/three-llms)
  - [Three + one LLms](chat/three-plus-one-llms)

#### Tools

Access a collection of tools designed to enhance your experience with The Cyber Boardroom. From markdown examples and spelling and grammar tools to GitHub guidance and support for programming languages like Portuguese, these resources are here to assist you.

 - [Markdown Examples](docs/markdown/examples)
 - [Spelling and grammar](docs/tools/spelling-grammar-helper)
 - [GitHub guidance and support](docs/tools/github-helper)
 - [Portuguese as a programming language](docs/tools/portuguese-journalist)