"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseScalableAttribute = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const scalable_target_1 = require("./scalable-target");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * Represent an attribute for which autoscaling can be configured
 *
 * This class is basically a light wrapper around ScalableTarget, but with
 * all methods protected instead of public so they can be selectively
 * exposed and/or more specific versions of them can be exposed by derived
 * classes for individual services support autoscaling.
 *
 * Typical use cases:
 *
 * - Hide away the PredefinedMetric enum for target tracking policies.
 * - Don't expose all scaling methods (for example Dynamo tables don't support
 *   Step Scaling, so the Dynamo subclass won't expose this method).
 */
class BaseScalableAttribute extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_BaseScalableAttributeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.target = new scalable_target_1.ScalableTarget(this, 'Target', {
            serviceNamespace: this.props.serviceNamespace,
            scalableDimension: this.props.dimension,
            resourceId: this.props.resourceId,
            role: this.props.role,
            minCapacity: (_b = props.minCapacity) !== null && _b !== void 0 ? _b : 1,
            maxCapacity: props.maxCapacity,
        });
    }
    /**
     * Scale out or in based on time
     */
    doScaleOnSchedule(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_ScalingSchedule(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.doScaleOnSchedule);
            }
            throw error;
        }
        this.target.scaleOnSchedule(id, props);
    }
    /**
     * Scale out or in based on a metric value
     */
    doScaleOnMetric(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_BasicStepScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.doScaleOnMetric);
            }
            throw error;
        }
        this.target.scaleOnMetric(id, props);
    }
    /**
     * Scale out or in in order to keep a metric around a target value
     */
    doScaleToTrackMetric(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_BasicTargetTrackingScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.doScaleToTrackMetric);
            }
            throw error;
        }
        this.target.scaleToTrackMetric(id, props);
    }
}
exports.BaseScalableAttribute = BaseScalableAttribute;
_a = JSII_RTTI_SYMBOL_1;
BaseScalableAttribute[_a] = { fqn: "@aws-cdk/aws-applicationautoscaling.BaseScalableAttribute", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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