# auto-generated by pywriter.py, do not edit or commit

from openpower.decoder.isa.caller import inject, instruction_info
from openpower.decoder.helpers import (EXTS, EXTS64, EXTZ64, ROTL64, ROTL32,
                                 MASK, ne, eq, gt, ge, lt, le, ltu, gtu, length,
                                 trunc_divs, trunc_rems, MULS, DIVS, MODS,
                                 EXTS128, undefined)
from openpower.decoder.selectable_int import SelectableInt
from openpower.decoder.selectable_int import selectconcat as concat
from openpower.decoder.orderedset import OrderedSet

class fixedlogical:

    @inject()
    def op_andi_(self, RS):
        RA = RS & concat(concat(0, repeat=48), UI)
        return (RA,)

    @inject()
    def op_ori(self, RS):
        RA = RS | concat(concat(0, repeat=48), UI)
        return (RA,)

    @inject()
    def op_andis_(self, RS):
        RA = RS & concat(concat(0, repeat=32), UI, concat(0, repeat=16))
        return (RA,)

    @inject()
    def op_oris(self, RS):
        RA = RS | concat(concat(0, repeat=32), UI, concat(0, repeat=16))
        return (RA,)

    @inject()
    def op_xoris(self, RS):
        RA = RS ^ concat(concat(0, repeat=32), UI, concat(0, repeat=16))
        return (RA,)

    @inject()
    def op_xori(self, RS):
        RA = RS ^ concat(concat(0, repeat=48), UI)
        return (RA,)

    @inject()
    def op_and(self, RS, RB):
        RA = RS & RB
        return (RA,)

    @inject()
    def op_and_(self, RS, RB):
        RA = RS & RB
        return (RA,)

    @inject()
    def op_or(self, RS, RB):
        RA = RS | RB
        return (RA,)

    @inject()
    def op_or_(self, RS, RB):
        RA = RS | RB
        return (RA,)

    @inject()
    def op_xor(self, RS, RB):
        RA = RS ^ RB
        return (RA,)

    @inject()
    def op_xor_(self, RS, RB):
        RA = RS ^ RB
        return (RA,)

    @inject()
    def op_nand(self, RS, RB):
        RA = ~(RS & RB)
        return (RA,)

    @inject()
    def op_nand_(self, RS, RB):
        RA = ~(RS & RB)
        return (RA,)

    @inject()
    def op_nor(self, RS, RB):
        RA = ~(RS | RB)
        return (RA,)

    @inject()
    def op_nor_(self, RS, RB):
        RA = ~(RS | RB)
        return (RA,)

    @inject()
    def op_eqv(self, RS, RB):
        RA = ~(RS ^ RB)
        return (RA,)

    @inject()
    def op_eqv_(self, RS, RB):
        RA = ~(RS ^ RB)
        return (RA,)

    @inject()
    def op_andc(self, RS, RB):
        RA = RS & ~RB
        return (RA,)

    @inject()
    def op_andc_(self, RS, RB):
        RA = RS & ~RB
        return (RA,)

    @inject()
    def op_orc(self, RS, RB):
        RA = RS | ~RB
        return (RA,)

    @inject()
    def op_orc_(self, RS, RB):
        RA = RS | ~RB
        return (RA,)

    @inject()
    def op_extsb(self, RS, RA):
        s = RS[56]
        RA[56:64] = RS[56:64]
        RA[0:56] = concat(s, repeat=56)
        return (RA,)

    @inject()
    def op_extsb_(self, RS, RA):
        s = RS[56]
        RA[56:64] = RS[56:64]
        RA[0:56] = concat(s, repeat=56)
        return (RA,)

    @inject()
    def op_extsh(self, RS, RA):
        s = RS[48]
        RA[48:64] = RS[48:64]
        RA[0:48] = concat(s, repeat=48)
        return (RA,)

    @inject()
    def op_extsh_(self, RS, RA):
        s = RS[48]
        RA[48:64] = RS[48:64]
        RA[0:48] = concat(s, repeat=48)
        return (RA,)

    @inject()
    def op_cntlzw(self, RS):
        n = 32
        while lt(n, 64):
            if eq(RS[n], 1):
                break
            n = n + 1
        RA = n - 32
        return (RA,)

    @inject()
    def op_cntlzw_(self, RS):
        n = 32
        while lt(n, 64):
            if eq(RS[n], 1):
                break
            n = n + 1
        RA = n - 32
        return (RA,)

    @inject()
    def op_cnttzw(self, RS):
        n = 0
        while lt(n, 32):
            if eq(RS[63 - n], SelectableInt(value=0x1, bits=1)):
                break
            n = n + 1
        RA = EXTZ64(n)
        return (RA,)

    @inject()
    def op_cnttzw_(self, RS):
        n = 0
        while lt(n, 32):
            if eq(RS[63 - n], SelectableInt(value=0x1, bits=1)):
                break
            n = n + 1
        RA = EXTZ64(n)
        return (RA,)

    @inject()
    def op_cmpb(self, RS, RB, RA):
        for n in range(0, 7 + 1):
            if eq(RS[8 * n:8 * n + 7 + 1], RB[8 * n:8 * n + 7 + 1]):
                RA[8 * n:8 * n + 7 + 1] = concat(1, repeat=8)
            else:
                RA[8 * n:8 * n + 7 + 1] = concat(0, repeat=8)
        return (RA,)

    @inject()
    def op_popcntb(self, RS, RA):
        for i in range(0, 7 + 1):
            n = 0
            for j in range(0, 7 + 1):
                if eq(RS[i * 8 + j], 1):
                    n = n + 1
            RA[i * 8:i * 8 + 7 + 1] = n
        return (RA,)

    @inject()
    def op_popcntw(self, RS, RA):
        for i in range(0, 1 + 1):
            n = 0
            for j in range(0, 31 + 1):
                if eq(RS[i * 32 + j], 1):
                    n = n + 1
            RA[i * 32:i * 32 + 31 + 1] = n
        return (RA,)

    @inject()
    def op_prtyd(self, RS):
        s = 0
        for i in range(0, 7 + 1):
            s = s ^ RS[i * 8 + 7]
        RA = concat(concat(0, repeat=63), s)
        return (RA,)

    @inject()
    def op_prtyw(self, RS, RA):
        s = 0
        t = 0
        for i in range(0, 3 + 1):
            s = s ^ RS[i * 8 + 7]
        for i in range(4, 7 + 1):
            t = t ^ RS[i * 8 + 7]
        RA[0:32] = concat(concat(0, repeat=31), s)
        RA[32:64] = concat(concat(0, repeat=31), t)
        return (RA,)

    @inject()
    def op_extsw(self, RS, RA):
        s = RS[32]
        RA[32:64] = RS[32:64]
        RA[0:32] = concat(s, repeat=32)
        return (RA,)

    @inject()
    def op_extsw_(self, RS, RA):
        s = RS[32]
        RA[32:64] = RS[32:64]
        RA[0:32] = concat(s, repeat=32)
        return (RA,)

    @inject()
    def op_popcntd(self, RS):
        n = 0
        for i in range(0, 63 + 1):
            if eq(RS[i], 1):
                n = n + 1
        RA = n
        return (RA,)

    @inject()
    def op_cntlzd(self, RS):
        n = 0
        while lt(n, 64):
            if eq(RS[n], 1):
                break
            n = n + 1
        RA = n
        return (RA,)

    @inject()
    def op_cntlzd_(self, RS):
        n = 0
        while lt(n, 64):
            if eq(RS[n], 1):
                break
            n = n + 1
        RA = n
        return (RA,)

    @inject()
    def op_cnttzd(self, RS):
        n = 0
        while lt(n, 64):
            if eq(RS[63 - n], SelectableInt(value=0x1, bits=1)):
                break
            n = n + 1
        RA = EXTZ64(n)
        return (RA,)

    @inject()
    def op_cnttzd_(self, RS):
        n = 0
        while lt(n, 64):
            if eq(RS[63 - n], SelectableInt(value=0x1, bits=1)):
                break
            n = n + 1
        RA = EXTZ64(n)
        return (RA,)

    @inject()
    def op_bpermd(self, RS, RB):
        perm = concat(0, repeat=8)
        for i in range(0, 7 + 1):
            index = RS[8 * i:8 * i + 7 + 1]
            if lt(index, 64):
                perm[i] = RB[index]
            else:
                perm[i] = 0
        RA = concat(concat(0, repeat=56), perm[0:8])
        return (RA,)

    fixedlogical_instrs = {}
    fixedlogical_instrs['andi.'] = instruction_info(func=op_andi_,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['UI']),
                form='D',
                asmregs=[['RA', 'RS', 'UI']])
    fixedlogical_instrs['ori'] = instruction_info(func=op_ori,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['UI']),
                form='D',
                asmregs=[['RA', 'RS', 'UI']])
    fixedlogical_instrs['andis.'] = instruction_info(func=op_andis_,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['UI']),
                form='D',
                asmregs=[['RA', 'RS', 'UI']])
    fixedlogical_instrs['oris'] = instruction_info(func=op_oris,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['UI']),
                form='D',
                asmregs=[['RA', 'RS', 'UI']])
    fixedlogical_instrs['xoris'] = instruction_info(func=op_xoris,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['UI']),
                form='D',
                asmregs=[['RA', 'RS', 'UI']])
    fixedlogical_instrs['xori'] = instruction_info(func=op_xori,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['UI']),
                form='D',
                asmregs=[['RA', 'RS', 'UI']])
    fixedlogical_instrs['and'] = instruction_info(func=op_and,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['and.'] = instruction_info(func=op_and_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['or'] = instruction_info(func=op_or,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['or.'] = instruction_info(func=op_or_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['xor'] = instruction_info(func=op_xor,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['xor.'] = instruction_info(func=op_xor_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['nand'] = instruction_info(func=op_nand,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['nand.'] = instruction_info(func=op_nand_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['nor'] = instruction_info(func=op_nor,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['nor.'] = instruction_info(func=op_nor_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['eqv'] = instruction_info(func=op_eqv,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['eqv.'] = instruction_info(func=op_eqv_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['andc'] = instruction_info(func=op_andc,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['andc.'] = instruction_info(func=op_andc_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['orc'] = instruction_info(func=op_orc,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=0)'])
    fixedlogical_instrs['orc.'] = instruction_info(func=op_orc_,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB'], '(Rc=1)'])
    fixedlogical_instrs['extsb'] = instruction_info(func=op_extsb,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=0)'])
    fixedlogical_instrs['extsb.'] = instruction_info(func=op_extsb_,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=1)'])
    fixedlogical_instrs['extsh'] = instruction_info(func=op_extsh,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=0)'])
    fixedlogical_instrs['extsh.'] = instruction_info(func=op_extsh_,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=1)'])
    fixedlogical_instrs['cntlzw'] = instruction_info(func=op_cntlzw,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=0)'])
    fixedlogical_instrs['cntlzw.'] = instruction_info(func=op_cntlzw_,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=1)'])
    fixedlogical_instrs['cnttzw'] = instruction_info(func=op_cnttzw,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=0)'])
    fixedlogical_instrs['cnttzw.'] = instruction_info(func=op_cnttzw_,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=1)'])
    fixedlogical_instrs['cmpb'] = instruction_info(func=op_cmpb,
                read_regs=OrderedSet(['RS', 'RB', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB']])
    fixedlogical_instrs['popcntb'] = instruction_info(func=op_popcntb,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', ''], 'RS'])
    fixedlogical_instrs['popcntw'] = instruction_info(func=op_popcntw,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', ''], 'RS'])
    fixedlogical_instrs['prtyd'] = instruction_info(func=op_prtyd,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS']])
    fixedlogical_instrs['prtyw'] = instruction_info(func=op_prtyw,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS']])
    fixedlogical_instrs['extsw'] = instruction_info(func=op_extsw,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=0)'])
    fixedlogical_instrs['extsw.'] = instruction_info(func=op_extsw_,
                read_regs=OrderedSet(['RS', 'RA']),
                uninit_regs=OrderedSet(['RA']), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=1)'])
    fixedlogical_instrs['popcntd'] = instruction_info(func=op_popcntd,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', ''], 'RS'])
    fixedlogical_instrs['cntlzd'] = instruction_info(func=op_cntlzd,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=0)'])
    fixedlogical_instrs['cntlzd.'] = instruction_info(func=op_cntlzd_,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=1)'])
    fixedlogical_instrs['cnttzd'] = instruction_info(func=op_cnttzd,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=0)'])
    fixedlogical_instrs['cnttzd.'] = instruction_info(func=op_cnttzd_,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS'], '(Rc=1)'])
    fixedlogical_instrs['bpermd'] = instruction_info(func=op_bpermd,
                read_regs=OrderedSet(['RS', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RA']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RS', 'RB]']])
