# auto-generated by pywriter.py, do not edit or commit

from openpower.decoder.isa.caller import inject, instruction_info
from openpower.decoder.helpers import (EXTS, EXTS64, EXTZ64, ROTL64, ROTL32,
                                 MASK, ne, eq, gt, ge, lt, le, ltu, gtu, length,
                                 trunc_divs, trunc_rems, MULS, DIVS, MODS,
                                 EXTS128, undefined)
from openpower.decoder.selectable_int import SelectableInt
from openpower.decoder.selectable_int import selectconcat as concat
from openpower.decoder.orderedset import OrderedSet

class comparefixed:

    @inject()
    def op_cmpi(self, RA, CR):
        if eq(L, 0):
            a = EXTS(RA[32:64])
        else:
            a = RA
        if lt(a, EXTS(SI)):
            c = SelectableInt(value=0x4, bits=3)
        elif gt(a, EXTS(SI)):
            c = SelectableInt(value=0x2, bits=3)
        else:
            c = SelectableInt(value=0x1, bits=3)
        CR[4 * BF + 32:4 * BF + 35 + 1] = concat(c, XER[SO])
        return (CR,)

    @inject()
    def op_cmp(self, RA, RB, CR):
        if eq(L, 0):
            a = EXTS(RA[32:64])
            b = EXTS(RB[32:64])
        else:
            a = RA
            b = RB
        if lt(a, b):
            c = SelectableInt(value=0x4, bits=3)
        elif gt(a, b):
            c = SelectableInt(value=0x2, bits=3)
        else:
            c = SelectableInt(value=0x1, bits=3)
        CR[4 * BF + 32:4 * BF + 35 + 1] = concat(c, XER[SO])
        return (CR,)

    @inject()
    def op_cmpli(self, RA, CR):
        if eq(L, 0):
            a = concat(concat(0, repeat=32), RA[32:64])
        else:
            a = RA
        if ltu(a, concat(concat(0, repeat=48), UI)):
            c = SelectableInt(value=0x4, bits=3)
        elif gtu(a, concat(concat(0, repeat=48), UI)):
            c = SelectableInt(value=0x2, bits=3)
        else:
            c = SelectableInt(value=0x1, bits=3)
        CR[4 * BF + 32:4 * BF + 35 + 1] = concat(c, XER[SO])
        return (CR,)

    @inject()
    def op_cmpl(self, RA, RB, CR):
        if eq(L, 0):
            a = concat(concat(0, repeat=32), RA[32:64])
            b = concat(concat(0, repeat=32), RB[32:64])
        else:
            a = RA
            b = RB
        if ltu(a, b):
            c = SelectableInt(value=0x4, bits=3)
        elif gtu(a, b):
            c = SelectableInt(value=0x2, bits=3)
        else:
            c = SelectableInt(value=0x1, bits=3)
        CR[4 * BF + 32:4 * BF + 35 + 1] = concat(c, XER[SO])
        return (CR,)

    @inject()
    def op_cmprb(self, RA, RB, CR):
        src1 = EXTZ(RA[56:64])
        src21hi = EXTZ(RB[32:40])
        src21lo = EXTZ(RB[40:48])
        src22hi = EXTZ(RB[48:56])
        src22lo = EXTZ(RB[56:64])
        if eq(L, 0):
            in_range = le(src22lo, src1) & le(src1, src22hi)
        else:
            in_range = le(src21lo, src1) & le(src1, src21hi) | le(src22lo, src1) & le(
                src1, src22hi)
        CR[4 * BF + 32] = SelectableInt(value=0x0, bits=1)
        CR[4 * BF + 33] = in_range
        CR[4 * BF + 34] = SelectableInt(value=0x0, bits=1)
        CR[4 * BF + 35] = SelectableInt(value=0x0, bits=1)
        return (CR,)

    @inject()
    def op_cmpeqb(self, RA, RB, CR):
        src1 = RA[56:64]
        match = eq(src1, RB[0:8]) | eq(src1, RB[8:16]) | eq(src1, RB[16:24]) | eq(src1,
            RB[24:32]) | eq(src1, RB[32:40]) | eq(src1, RB[40:48]) | eq(src1, RB[48:56]
            ) | eq(src1, RB[56:64])
        CR[4 * BF + 32] = SelectableInt(value=0x0, bits=1)
        CR[4 * BF + 33] = match
        CR[4 * BF + 34] = SelectableInt(value=0x0, bits=1)
        CR[4 * BF + 35] = SelectableInt(value=0x0, bits=1)
        return (CR,)

    comparefixed_instrs = {}
    comparefixed_instrs['cmpi'] = instruction_info(func=op_cmpi,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['L', 'SI', 'BF']),
                form='D',
                asmregs=[['BF', 'L', 'RA', 'SI']])
    comparefixed_instrs['cmp'] = instruction_info(func=op_cmp,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['L', 'BF']),
                form='X',
                asmregs=[['BF', 'L', 'RA', 'RB']])
    comparefixed_instrs['cmpli'] = instruction_info(func=op_cmpli,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['L', 'UI', 'BF']),
                form='D',
                asmregs=[['BF', 'L', 'RA', 'UI']])
    comparefixed_instrs['cmpl'] = instruction_info(func=op_cmpl,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['L', 'BF']),
                form='X',
                asmregs=[['BF', 'L', 'RA', 'RB']])
    comparefixed_instrs['cmprb'] = instruction_info(func=op_cmprb,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['L', 'BF']),
                form='X',
                asmregs=[['BF', 'L', 'RA', 'RB']])
    comparefixed_instrs['cmpeqb'] = instruction_info(func=op_cmpeqb,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['BF']),
                form='X',
                asmregs=[['BF', 'RA', 'RB']])
