# SPDX-License-Identifier: GPL-3.0-only
# (C) Copyright CERN 2021. All rights not expressly granted are reserved. 

import numpy
from numpy.random import binomial

from availsim4core.src.context.system.probability_law.probability_law import ProbabilityLaw


class BinomialLaw(ProbabilityLaw):
    """
    Class used to generate values according to the Binomial law
    """

    def __init__(self,
                 parameters):
        super().__init__(self.__class__.__name__,
                         parameters,
                         is_failure_on_demand=True)

    def __eq__(self, other):
        if not isinstance(other, BinomialLaw):
            return NotImplemented
        return super().__eq__(other)

    def get_random_value(self):
        return binomial(1, self.parameters[0])

    def get_quantile_value(self, quantile):
        return quantile <= self.parameters[0]

    def get_mean_value(self):
        return self.parameters[0]

    def get_variance_value(self):
        return self.parameters[0]*(1-self.parameters[0])
