# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 deduplication_scope: Optional[pulumi.Input[str]] = None,
                 delay_seconds: Optional[pulumi.Input[int]] = None,
                 fifo_queue: Optional[pulumi.Input[bool]] = None,
                 fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
                 kms_data_key_reuse_period_seconds: Optional[pulumi.Input[int]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 maximum_message_size: Optional[pulumi.Input[int]] = None,
                 message_retention_period: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 receive_message_wait_time_seconds: Optional[pulumi.Input[int]] = None,
                 redrive_allow_policy: Optional[Any] = None,
                 redrive_policy: Optional[Any] = None,
                 sqs_managed_sse_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['QueueTagArgs']]]] = None,
                 visibility_timeout: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input[bool] content_based_deduplication: For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication. During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message.
        :param pulumi.Input[str] deduplication_scope: Specifies whether message deduplication occurs at the message group or queue level. Valid values are messageGroup and queue.
        :param pulumi.Input[int] delay_seconds: The time in seconds for which the delivery of all messages in the queue is delayed. You can specify an integer value of 0 to 900 (15 minutes). The default value is 0.
        :param pulumi.Input[bool] fifo_queue: If set to true, creates a FIFO queue. If you don't specify this property, Amazon SQS creates a standard queue.
        :param pulumi.Input[str] fifo_throughput_limit: Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are perQueue and perMessageGroupId. The perMessageGroupId value is allowed only when the value for DeduplicationScope is messageGroup.
        :param pulumi.Input[int] kms_data_key_reuse_period_seconds: The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK. To use the AWS managed CMK for Amazon SQS, specify the (default) alias alias/aws/sqs.
        :param pulumi.Input[int] maximum_message_size: The limit of how many bytes that a message can contain before Amazon SQS rejects it. You can specify an integer value from 1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). The default value is 262,144 (256 KiB).
        :param pulumi.Input[int] message_retention_period: The number of seconds that Amazon SQS retains a message. You can specify an integer value from 60 seconds (1 minute) to 1,209,600 seconds (14 days). The default value is 345,600 seconds (4 days).
        :param pulumi.Input[str] queue_name: A name for the queue. To create a FIFO queue, the name of your FIFO queue must end with the .fifo suffix.
        :param pulumi.Input[int] receive_message_wait_time_seconds: Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available. You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property.
        :param Any redrive_allow_policy: The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
        :param Any redrive_policy: A string that includes the parameters for the dead-letter queue functionality (redrive policy) of the source queue.
        :param pulumi.Input[bool] sqs_managed_sse_enabled: Enables server-side queue encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue (e.g. SSE-KMS or SSE-SQS ).
        :param pulumi.Input[Sequence[pulumi.Input['QueueTagArgs']]] tags: The tags that you attach to this queue.
        :param pulumi.Input[int] visibility_timeout: The length of time during which a message will be unavailable after a message is delivered from the queue. This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue. Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
        """
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if deduplication_scope is not None:
            pulumi.set(__self__, "deduplication_scope", deduplication_scope)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if fifo_queue is not None:
            pulumi.set(__self__, "fifo_queue", fifo_queue)
        if fifo_throughput_limit is not None:
            pulumi.set(__self__, "fifo_throughput_limit", fifo_throughput_limit)
        if kms_data_key_reuse_period_seconds is not None:
            pulumi.set(__self__, "kms_data_key_reuse_period_seconds", kms_data_key_reuse_period_seconds)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if maximum_message_size is not None:
            pulumi.set(__self__, "maximum_message_size", maximum_message_size)
        if message_retention_period is not None:
            pulumi.set(__self__, "message_retention_period", message_retention_period)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if receive_message_wait_time_seconds is not None:
            pulumi.set(__self__, "receive_message_wait_time_seconds", receive_message_wait_time_seconds)
        if redrive_allow_policy is not None:
            pulumi.set(__self__, "redrive_allow_policy", redrive_allow_policy)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if sqs_managed_sse_enabled is not None:
            pulumi.set(__self__, "sqs_managed_sse_enabled", sqs_managed_sse_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility_timeout is not None:
            pulumi.set(__self__, "visibility_timeout", visibility_timeout)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication. During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="deduplicationScope")
    def deduplication_scope(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether message deduplication occurs at the message group or queue level. Valid values are messageGroup and queue.
        """
        return pulumi.get(self, "deduplication_scope")

    @deduplication_scope.setter
    def deduplication_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deduplication_scope", value)

    @property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds for which the delivery of all messages in the queue is delayed. You can specify an integer value of 0 to 900 (15 minutes). The default value is 0.
        """
        return pulumi.get(self, "delay_seconds")

    @delay_seconds.setter
    def delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_seconds", value)

    @property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, creates a FIFO queue. If you don't specify this property, Amazon SQS creates a standard queue.
        """
        return pulumi.get(self, "fifo_queue")

    @fifo_queue.setter
    def fifo_queue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_queue", value)

    @property
    @pulumi.getter(name="fifoThroughputLimit")
    def fifo_throughput_limit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are perQueue and perMessageGroupId. The perMessageGroupId value is allowed only when the value for DeduplicationScope is messageGroup.
        """
        return pulumi.get(self, "fifo_throughput_limit")

    @fifo_throughput_limit.setter
    def fifo_throughput_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fifo_throughput_limit", value)

    @property
    @pulumi.getter(name="kmsDataKeyReusePeriodSeconds")
    def kms_data_key_reuse_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
        """
        return pulumi.get(self, "kms_data_key_reuse_period_seconds")

    @kms_data_key_reuse_period_seconds.setter
    def kms_data_key_reuse_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "kms_data_key_reuse_period_seconds", value)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK. To use the AWS managed CMK for Amazon SQS, specify the (default) alias alias/aws/sqs.
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_master_key_id", value)

    @property
    @pulumi.getter(name="maximumMessageSize")
    def maximum_message_size(self) -> Optional[pulumi.Input[int]]:
        """
        The limit of how many bytes that a message can contain before Amazon SQS rejects it. You can specify an integer value from 1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). The default value is 262,144 (256 KiB).
        """
        return pulumi.get(self, "maximum_message_size")

    @maximum_message_size.setter
    def maximum_message_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_message_size", value)

    @property
    @pulumi.getter(name="messageRetentionPeriod")
    def message_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds that Amazon SQS retains a message. You can specify an integer value from 60 seconds (1 minute) to 1,209,600 seconds (14 days). The default value is 345,600 seconds (4 days).
        """
        return pulumi.get(self, "message_retention_period")

    @message_retention_period.setter
    def message_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "message_retention_period", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the queue. To create a FIFO queue, the name of your FIFO queue must end with the .fifo suffix.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter(name="receiveMessageWaitTimeSeconds")
    def receive_message_wait_time_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available. You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property.
        """
        return pulumi.get(self, "receive_message_wait_time_seconds")

    @receive_message_wait_time_seconds.setter
    def receive_message_wait_time_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "receive_message_wait_time_seconds", value)

    @property
    @pulumi.getter(name="redriveAllowPolicy")
    def redrive_allow_policy(self) -> Optional[Any]:
        """
        The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
        """
        return pulumi.get(self, "redrive_allow_policy")

    @redrive_allow_policy.setter
    def redrive_allow_policy(self, value: Optional[Any]):
        pulumi.set(self, "redrive_allow_policy", value)

    @property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[Any]:
        """
        A string that includes the parameters for the dead-letter queue functionality (redrive policy) of the source queue.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[Any]):
        pulumi.set(self, "redrive_policy", value)

    @property
    @pulumi.getter(name="sqsManagedSseEnabled")
    def sqs_managed_sse_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables server-side queue encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue (e.g. SSE-KMS or SSE-SQS ).
        """
        return pulumi.get(self, "sqs_managed_sse_enabled")

    @sqs_managed_sse_enabled.setter
    def sqs_managed_sse_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sqs_managed_sse_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueueTagArgs']]]]:
        """
        The tags that you attach to this queue.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueueTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="visibilityTimeout")
    def visibility_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The length of time during which a message will be unavailable after a message is delivered from the queue. This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue. Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
        """
        return pulumi.get(self, "visibility_timeout")

    @visibility_timeout.setter
    def visibility_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "visibility_timeout", value)


class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 deduplication_scope: Optional[pulumi.Input[str]] = None,
                 delay_seconds: Optional[pulumi.Input[int]] = None,
                 fifo_queue: Optional[pulumi.Input[bool]] = None,
                 fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
                 kms_data_key_reuse_period_seconds: Optional[pulumi.Input[int]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 maximum_message_size: Optional[pulumi.Input[int]] = None,
                 message_retention_period: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 receive_message_wait_time_seconds: Optional[pulumi.Input[int]] = None,
                 redrive_allow_policy: Optional[Any] = None,
                 redrive_policy: Optional[Any] = None,
                 sqs_managed_sse_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QueueTagArgs']]]]] = None,
                 visibility_timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SQS::Queue

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] content_based_deduplication: For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication. During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message.
        :param pulumi.Input[str] deduplication_scope: Specifies whether message deduplication occurs at the message group or queue level. Valid values are messageGroup and queue.
        :param pulumi.Input[int] delay_seconds: The time in seconds for which the delivery of all messages in the queue is delayed. You can specify an integer value of 0 to 900 (15 minutes). The default value is 0.
        :param pulumi.Input[bool] fifo_queue: If set to true, creates a FIFO queue. If you don't specify this property, Amazon SQS creates a standard queue.
        :param pulumi.Input[str] fifo_throughput_limit: Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are perQueue and perMessageGroupId. The perMessageGroupId value is allowed only when the value for DeduplicationScope is messageGroup.
        :param pulumi.Input[int] kms_data_key_reuse_period_seconds: The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK. To use the AWS managed CMK for Amazon SQS, specify the (default) alias alias/aws/sqs.
        :param pulumi.Input[int] maximum_message_size: The limit of how many bytes that a message can contain before Amazon SQS rejects it. You can specify an integer value from 1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). The default value is 262,144 (256 KiB).
        :param pulumi.Input[int] message_retention_period: The number of seconds that Amazon SQS retains a message. You can specify an integer value from 60 seconds (1 minute) to 1,209,600 seconds (14 days). The default value is 345,600 seconds (4 days).
        :param pulumi.Input[str] queue_name: A name for the queue. To create a FIFO queue, the name of your FIFO queue must end with the .fifo suffix.
        :param pulumi.Input[int] receive_message_wait_time_seconds: Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available. You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property.
        :param Any redrive_allow_policy: The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
        :param Any redrive_policy: A string that includes the parameters for the dead-letter queue functionality (redrive policy) of the source queue.
        :param pulumi.Input[bool] sqs_managed_sse_enabled: Enables server-side queue encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue (e.g. SSE-KMS or SSE-SQS ).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QueueTagArgs']]]] tags: The tags that you attach to this queue.
        :param pulumi.Input[int] visibility_timeout: The length of time during which a message will be unavailable after a message is delivered from the queue. This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue. Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[QueueArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SQS::Queue

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 deduplication_scope: Optional[pulumi.Input[str]] = None,
                 delay_seconds: Optional[pulumi.Input[int]] = None,
                 fifo_queue: Optional[pulumi.Input[bool]] = None,
                 fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
                 kms_data_key_reuse_period_seconds: Optional[pulumi.Input[int]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 maximum_message_size: Optional[pulumi.Input[int]] = None,
                 message_retention_period: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 receive_message_wait_time_seconds: Optional[pulumi.Input[int]] = None,
                 redrive_allow_policy: Optional[Any] = None,
                 redrive_policy: Optional[Any] = None,
                 sqs_managed_sse_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QueueTagArgs']]]]] = None,
                 visibility_timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["deduplication_scope"] = deduplication_scope
            __props__.__dict__["delay_seconds"] = delay_seconds
            __props__.__dict__["fifo_queue"] = fifo_queue
            __props__.__dict__["fifo_throughput_limit"] = fifo_throughput_limit
            __props__.__dict__["kms_data_key_reuse_period_seconds"] = kms_data_key_reuse_period_seconds
            __props__.__dict__["kms_master_key_id"] = kms_master_key_id
            __props__.__dict__["maximum_message_size"] = maximum_message_size
            __props__.__dict__["message_retention_period"] = message_retention_period
            __props__.__dict__["queue_name"] = queue_name
            __props__.__dict__["receive_message_wait_time_seconds"] = receive_message_wait_time_seconds
            __props__.__dict__["redrive_allow_policy"] = redrive_allow_policy
            __props__.__dict__["redrive_policy"] = redrive_policy
            __props__.__dict__["sqs_managed_sse_enabled"] = sqs_managed_sse_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility_timeout"] = visibility_timeout
            __props__.__dict__["arn"] = None
            __props__.__dict__["queue_url"] = None
        super(Queue, __self__).__init__(
            'aws-native:sqs:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = QueueArgs.__new__(QueueArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["content_based_deduplication"] = None
        __props__.__dict__["deduplication_scope"] = None
        __props__.__dict__["delay_seconds"] = None
        __props__.__dict__["fifo_queue"] = None
        __props__.__dict__["fifo_throughput_limit"] = None
        __props__.__dict__["kms_data_key_reuse_period_seconds"] = None
        __props__.__dict__["kms_master_key_id"] = None
        __props__.__dict__["maximum_message_size"] = None
        __props__.__dict__["message_retention_period"] = None
        __props__.__dict__["queue_name"] = None
        __props__.__dict__["queue_url"] = None
        __props__.__dict__["receive_message_wait_time_seconds"] = None
        __props__.__dict__["redrive_allow_policy"] = None
        __props__.__dict__["redrive_policy"] = None
        __props__.__dict__["sqs_managed_sse_enabled"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["visibility_timeout"] = None
        return Queue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[Optional[bool]]:
        """
        For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication. During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message.
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="deduplicationScope")
    def deduplication_scope(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether message deduplication occurs at the message group or queue level. Valid values are messageGroup and queue.
        """
        return pulumi.get(self, "deduplication_scope")

    @property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The time in seconds for which the delivery of all messages in the queue is delayed. You can specify an integer value of 0 to 900 (15 minutes). The default value is 0.
        """
        return pulumi.get(self, "delay_seconds")

    @property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to true, creates a FIFO queue. If you don't specify this property, Amazon SQS creates a standard queue.
        """
        return pulumi.get(self, "fifo_queue")

    @property
    @pulumi.getter(name="fifoThroughputLimit")
    def fifo_throughput_limit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are perQueue and perMessageGroupId. The perMessageGroupId value is allowed only when the value for DeduplicationScope is messageGroup.
        """
        return pulumi.get(self, "fifo_throughput_limit")

    @property
    @pulumi.getter(name="kmsDataKeyReusePeriodSeconds")
    def kms_data_key_reuse_period_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
        """
        return pulumi.get(self, "kms_data_key_reuse_period_seconds")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK. To use the AWS managed CMK for Amazon SQS, specify the (default) alias alias/aws/sqs.
        """
        return pulumi.get(self, "kms_master_key_id")

    @property
    @pulumi.getter(name="maximumMessageSize")
    def maximum_message_size(self) -> pulumi.Output[Optional[int]]:
        """
        The limit of how many bytes that a message can contain before Amazon SQS rejects it. You can specify an integer value from 1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). The default value is 262,144 (256 KiB).
        """
        return pulumi.get(self, "maximum_message_size")

    @property
    @pulumi.getter(name="messageRetentionPeriod")
    def message_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The number of seconds that Amazon SQS retains a message. You can specify an integer value from 60 seconds (1 minute) to 1,209,600 seconds (14 days). The default value is 345,600 seconds (4 days).
        """
        return pulumi.get(self, "message_retention_period")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[Optional[str]]:
        """
        A name for the queue. To create a FIFO queue, the name of your FIFO queue must end with the .fifo suffix.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> pulumi.Output[str]:
        """
        URL of the source queue.
        """
        return pulumi.get(self, "queue_url")

    @property
    @pulumi.getter(name="receiveMessageWaitTimeSeconds")
    def receive_message_wait_time_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available. You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property.
        """
        return pulumi.get(self, "receive_message_wait_time_seconds")

    @property
    @pulumi.getter(name="redriveAllowPolicy")
    def redrive_allow_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
        """
        return pulumi.get(self, "redrive_allow_policy")

    @property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        A string that includes the parameters for the dead-letter queue functionality (redrive policy) of the source queue.
        """
        return pulumi.get(self, "redrive_policy")

    @property
    @pulumi.getter(name="sqsManagedSseEnabled")
    def sqs_managed_sse_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables server-side queue encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue (e.g. SSE-KMS or SSE-SQS ).
        """
        return pulumi.get(self, "sqs_managed_sse_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.QueueTag']]]:
        """
        The tags that you attach to this queue.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="visibilityTimeout")
    def visibility_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The length of time during which a message will be unavailable after a message is delivered from the queue. This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue. Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
        """
        return pulumi.get(self, "visibility_timeout")

