# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetContactListResult',
    'AwaitableGetContactListResult',
    'get_contact_list',
    'get_contact_list_output',
]

@pulumi.output_type
class GetContactListResult:
    def __init__(__self__, description=None, tags=None, topics=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the contact list.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ContactListTag']]:
        """
        The tags (keys and values) associated with the contact list.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence['outputs.ContactListTopic']]:
        """
        The topics associated with the contact list.
        """
        return pulumi.get(self, "topics")


class AwaitableGetContactListResult(GetContactListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactListResult(
            description=self.description,
            tags=self.tags,
            topics=self.topics)


def get_contact_list(contact_list_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactListResult:
    """
    Resource schema for AWS::SES::ContactList.


    :param str contact_list_name: The name of the contact list.
    """
    __args__ = dict()
    __args__['contactListName'] = contact_list_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ses:getContactList', __args__, opts=opts, typ=GetContactListResult).value

    return AwaitableGetContactListResult(
        description=__ret__.description,
        tags=__ret__.tags,
        topics=__ret__.topics)


@_utilities.lift_output_func(get_contact_list)
def get_contact_list_output(contact_list_name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContactListResult]:
    """
    Resource schema for AWS::SES::ContactList.


    :param str contact_list_name: The name of the contact list.
    """
    ...
