# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGlobalNetworkResult',
    'AwaitableGetGlobalNetworkResult',
    'get_global_network',
    'get_global_network_output',
]

@pulumi.output_type
class GetGlobalNetworkResult:
    def __init__(__self__, arn=None, description=None, id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the global network.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the global network.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the global network.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.GlobalNetworkTag']]:
        """
        The tags for the global network.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGlobalNetworkResult(GetGlobalNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalNetworkResult(
            arn=self.arn,
            description=self.description,
            id=self.id,
            tags=self.tags)


def get_global_network(id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalNetworkResult:
    """
    The AWS::NetworkManager::GlobalNetwork type specifies a global network of the user's account


    :param str id: The ID of the global network.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:networkmanager:getGlobalNetwork', __args__, opts=opts, typ=GetGlobalNetworkResult).value

    return AwaitableGetGlobalNetworkResult(
        arn=__ret__.arn,
        description=__ret__.description,
        id=__ret__.id,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_global_network)
def get_global_network_output(id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGlobalNetworkResult]:
    """
    The AWS::NetworkManager::GlobalNetwork type specifies a global network of the user's account


    :param str id: The ID of the global network.
    """
    ...
