# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceGroupArgs', 'ResourceGroup']

@pulumi.input_type
class ResourceGroupArgs:
    def __init__(__self__, *,
                 resource_group_tags: pulumi.Input[Sequence[pulumi.Input['ResourceGroupTagArgs']]]):
        """
        The set of arguments for constructing a ResourceGroup resource.
        """
        pulumi.set(__self__, "resource_group_tags", resource_group_tags)

    @property
    @pulumi.getter(name="resourceGroupTags")
    def resource_group_tags(self) -> pulumi.Input[Sequence[pulumi.Input['ResourceGroupTagArgs']]]:
        return pulumi.get(self, "resource_group_tags")

    @resource_group_tags.setter
    def resource_group_tags(self, value: pulumi.Input[Sequence[pulumi.Input['ResourceGroupTagArgs']]]):
        pulumi.set(self, "resource_group_tags", value)


class ResourceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_group_tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResourceGroupTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Inspector::ResourceGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Inspector::ResourceGroup

        :param str resource_name: The name of the resource.
        :param ResourceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_group_tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResourceGroupTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceGroupArgs.__new__(ResourceGroupArgs)

            if resource_group_tags is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_tags'")
            __props__.__dict__["resource_group_tags"] = resource_group_tags
            __props__.__dict__["arn"] = None
        super(ResourceGroup, __self__).__init__(
            'aws-native:inspector:ResourceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ResourceGroup':
        """
        Get an existing ResourceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ResourceGroupArgs.__new__(ResourceGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["resource_group_tags"] = None
        return ResourceGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="resourceGroupTags")
    def resource_group_tags(self) -> pulumi.Output[Sequence['outputs.ResourceGroupTag']]:
        return pulumi.get(self, "resource_group_tags")

