# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'DataRepositoryAssociationAutoExportPolicyArgs',
    'DataRepositoryAssociationAutoImportPolicyArgs',
    'DataRepositoryAssociationS3Args',
    'DataRepositoryAssociationTagArgs',
    'FileSystemAuditLogConfigurationArgs',
    'FileSystemClientConfigurationsArgs',
    'FileSystemDiskIopsConfigurationArgs',
    'FileSystemLustreConfigurationArgs',
    'FileSystemNfsExportsArgs',
    'FileSystemOntapConfigurationArgs',
    'FileSystemOpenZFSConfigurationArgs',
    'FileSystemRootVolumeConfigurationArgs',
    'FileSystemSelfManagedActiveDirectoryConfigurationArgs',
    'FileSystemTagArgs',
    'FileSystemUserAndGroupQuotasArgs',
    'FileSystemWindowsConfigurationArgs',
    'SnapshotTagArgs',
    'StorageVirtualMachineActiveDirectoryConfigurationArgs',
    'StorageVirtualMachineSelfManagedActiveDirectoryConfigurationArgs',
    'StorageVirtualMachineTagArgs',
    'VolumeClientConfigurationsArgs',
    'VolumeNfsExportsArgs',
    'VolumeOntapConfigurationArgs',
    'VolumeOpenZFSConfigurationArgs',
    'VolumeOriginSnapshotArgs',
    'VolumeTagArgs',
    'VolumeTieringPolicyArgs',
    'VolumeUserAndGroupQuotasArgs',
]

@pulumi.input_type
class DataRepositoryAssociationAutoExportPolicyArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationEventType']]]):
        """
        Specifies the type of updated objects (new, changed, deleted) that will be automatically exported from your file system to the linked S3 bucket.
        """
        pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationEventType']]]:
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationEventType']]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class DataRepositoryAssociationAutoImportPolicyArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationEventType']]]):
        """
        Specifies the type of updated objects (new, changed, deleted) that will be automatically imported from the linked S3 bucket to your file system.
        """
        pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationEventType']]]:
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationEventType']]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class DataRepositoryAssociationS3Args:
    def __init__(__self__, *,
                 auto_export_policy: Optional[pulumi.Input['DataRepositoryAssociationAutoExportPolicyArgs']] = None,
                 auto_import_policy: Optional[pulumi.Input['DataRepositoryAssociationAutoImportPolicyArgs']] = None):
        """
        The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        """
        if auto_export_policy is not None:
            pulumi.set(__self__, "auto_export_policy", auto_export_policy)
        if auto_import_policy is not None:
            pulumi.set(__self__, "auto_import_policy", auto_import_policy)

    @property
    @pulumi.getter(name="autoExportPolicy")
    def auto_export_policy(self) -> Optional[pulumi.Input['DataRepositoryAssociationAutoExportPolicyArgs']]:
        return pulumi.get(self, "auto_export_policy")

    @auto_export_policy.setter
    def auto_export_policy(self, value: Optional[pulumi.Input['DataRepositoryAssociationAutoExportPolicyArgs']]):
        pulumi.set(self, "auto_export_policy", value)

    @property
    @pulumi.getter(name="autoImportPolicy")
    def auto_import_policy(self) -> Optional[pulumi.Input['DataRepositoryAssociationAutoImportPolicyArgs']]:
        return pulumi.get(self, "auto_import_policy")

    @auto_import_policy.setter
    def auto_import_policy(self, value: Optional[pulumi.Input['DataRepositoryAssociationAutoImportPolicyArgs']]):
        pulumi.set(self, "auto_import_policy", value)


@pulumi.input_type
class DataRepositoryAssociationTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class FileSystemAuditLogConfigurationArgs:
    def __init__(__self__, *,
                 file_access_audit_log_level: pulumi.Input[str],
                 file_share_access_audit_log_level: pulumi.Input[str],
                 audit_log_destination: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)
        if audit_log_destination is not None:
            pulumi.set(__self__, "audit_log_destination", audit_log_destination)

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> pulumi.Input[str]:
        return pulumi.get(self, "file_access_audit_log_level")

    @file_access_audit_log_level.setter
    def file_access_audit_log_level(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_access_audit_log_level", value)

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> pulumi.Input[str]:
        return pulumi.get(self, "file_share_access_audit_log_level")

    @file_share_access_audit_log_level.setter
    def file_share_access_audit_log_level(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_share_access_audit_log_level", value)

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "audit_log_destination")

    @audit_log_destination.setter
    def audit_log_destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_log_destination", value)


@pulumi.input_type
class FileSystemClientConfigurationsArgs:
    def __init__(__self__, *,
                 clients: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if clients is not None:
            pulumi.set(__self__, "clients", clients)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class FileSystemDiskIopsConfigurationArgs:
    def __init__(__self__, *,
                 iops: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class FileSystemLustreConfigurationArgs:
    def __init__(__self__, *,
                 auto_import_policy: Optional[pulumi.Input[str]] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 drive_cache_type: Optional[pulumi.Input[str]] = None,
                 export_path: Optional[pulumi.Input[str]] = None,
                 import_path: Optional[pulumi.Input[str]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 per_unit_storage_throughput: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        if auto_import_policy is not None:
            pulumi.set(__self__, "auto_import_policy", auto_import_policy)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if drive_cache_type is not None:
            pulumi.set(__self__, "drive_cache_type", drive_cache_type)
        if export_path is not None:
            pulumi.set(__self__, "export_path", export_path)
        if import_path is not None:
            pulumi.set(__self__, "import_path", import_path)
        if imported_file_chunk_size is not None:
            pulumi.set(__self__, "imported_file_chunk_size", imported_file_chunk_size)
        if per_unit_storage_throughput is not None:
            pulumi.set(__self__, "per_unit_storage_throughput", per_unit_storage_throughput)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="autoImportPolicy")
    def auto_import_policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_import_policy")

    @auto_import_policy.setter
    def auto_import_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_import_policy", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="driveCacheType")
    def drive_cache_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "drive_cache_type")

    @drive_cache_type.setter
    def drive_cache_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "drive_cache_type", value)

    @property
    @pulumi.getter(name="exportPath")
    def export_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "export_path")

    @export_path.setter
    def export_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_path", value)

    @property
    @pulumi.getter(name="importPath")
    def import_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "import_path")

    @import_path.setter
    def import_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_path", value)

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "imported_file_chunk_size")

    @imported_file_chunk_size.setter
    def imported_file_chunk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "imported_file_chunk_size", value)

    @property
    @pulumi.getter(name="perUnitStorageThroughput")
    def per_unit_storage_throughput(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "per_unit_storage_throughput")

    @per_unit_storage_throughput.setter
    def per_unit_storage_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "per_unit_storage_throughput", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class FileSystemNfsExportsArgs:
    def __init__(__self__, *,
                 client_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemClientConfigurationsArgs']]]] = None):
        if client_configurations is not None:
            pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemClientConfigurationsArgs']]]]:
        return pulumi.get(self, "client_configurations")

    @client_configurations.setter
    def client_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemClientConfigurationsArgs']]]]):
        pulumi.set(self, "client_configurations", value)


@pulumi.input_type
class FileSystemOntapConfigurationArgs:
    def __init__(__self__, *,
                 deployment_type: pulumi.Input[str],
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['FileSystemDiskIopsConfigurationArgs']] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 fsx_admin_password: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "deployment_type", deployment_type)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if endpoint_ip_address_range is not None:
            pulumi.set(__self__, "endpoint_ip_address_range", endpoint_ip_address_range)
        if fsx_admin_password is not None:
            pulumi.set(__self__, "fsx_admin_password", fsx_admin_password)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['FileSystemDiskIopsConfigurationArgs']]:
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['FileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "endpoint_ip_address_range")

    @endpoint_ip_address_range.setter
    def endpoint_ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address_range", value)

    @property
    @pulumi.getter(name="fsxAdminPassword")
    def fsx_admin_password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "fsx_admin_password")

    @fsx_admin_password.setter
    def fsx_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fsx_admin_password", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class FileSystemOpenZFSConfigurationArgs:
    def __init__(__self__, *,
                 deployment_type: pulumi.Input[str],
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 copy_tags_to_volumes: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['FileSystemDiskIopsConfigurationArgs']] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 root_volume_configuration: Optional[pulumi.Input['FileSystemRootVolumeConfigurationArgs']] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "deployment_type", deployment_type)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if copy_tags_to_volumes is not None:
            pulumi.set(__self__, "copy_tags_to_volumes", copy_tags_to_volumes)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if root_volume_configuration is not None:
            pulumi.set(__self__, "root_volume_configuration", root_volume_configuration)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="copyTagsToVolumes")
    def copy_tags_to_volumes(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "copy_tags_to_volumes")

    @copy_tags_to_volumes.setter
    def copy_tags_to_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_volumes", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['FileSystemDiskIopsConfigurationArgs']]:
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['FileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="rootVolumeConfiguration")
    def root_volume_configuration(self) -> Optional[pulumi.Input['FileSystemRootVolumeConfigurationArgs']]:
        return pulumi.get(self, "root_volume_configuration")

    @root_volume_configuration.setter
    def root_volume_configuration(self, value: Optional[pulumi.Input['FileSystemRootVolumeConfigurationArgs']]):
        pulumi.set(self, "root_volume_configuration", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class FileSystemRootVolumeConfigurationArgs:
    def __init__(__self__, *,
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemNfsExportsArgs']]]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 record_size_ki_b: Optional[pulumi.Input[int]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemUserAndGroupQuotasArgs']]]] = None):
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_ki_b is not None:
            pulumi.set(__self__, "record_size_ki_b", record_size_ki_b)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemNfsExportsArgs']]]]:
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemNfsExportsArgs']]]]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recordSizeKiB")
    def record_size_ki_b(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "record_size_ki_b")

    @record_size_ki_b.setter
    def record_size_ki_b(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_size_ki_b", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemUserAndGroupQuotasArgs']]]]:
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemUserAndGroupQuotasArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)


@pulumi.input_type
class FileSystemSelfManagedActiveDirectoryConfigurationArgs:
    def __init__(__self__, *,
                 dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 file_system_administrators_group: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_system_administrators_group")

    @file_system_administrators_group.setter
    def file_system_administrators_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_administrators_group", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class FileSystemTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class FileSystemUserAndGroupQuotasArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[int]] = None,
                 storage_capacity_quota_gi_b: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if id is not None:
            pulumi.set(__self__, "id", id)
        if storage_capacity_quota_gi_b is not None:
            pulumi.set(__self__, "storage_capacity_quota_gi_b", storage_capacity_quota_gi_b)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGiB")
    def storage_capacity_quota_gi_b(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "storage_capacity_quota_gi_b")

    @storage_capacity_quota_gi_b.setter
    def storage_capacity_quota_gi_b(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity_quota_gi_b", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FileSystemWindowsConfigurationArgs:
    def __init__(__self__, *,
                 throughput_capacity: pulumi.Input[int],
                 active_directory_id: Optional[pulumi.Input[str]] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_log_configuration: Optional[pulumi.Input['FileSystemAuditLogConfigurationArgs']] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 self_managed_active_directory_configuration: Optional[pulumi.Input['FileSystemSelfManagedActiveDirectoryConfigurationArgs']] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if audit_log_configuration is not None:
            pulumi.set(__self__, "audit_log_configuration", audit_log_configuration)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> pulumi.Input[int]:
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "active_directory_id")

    @active_directory_id.setter
    def active_directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory_id", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="auditLogConfiguration")
    def audit_log_configuration(self) -> Optional[pulumi.Input['FileSystemAuditLogConfigurationArgs']]:
        return pulumi.get(self, "audit_log_configuration")

    @audit_log_configuration.setter
    def audit_log_configuration(self, value: Optional[pulumi.Input['FileSystemAuditLogConfigurationArgs']]):
        pulumi.set(self, "audit_log_configuration", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional[pulumi.Input['FileSystemSelfManagedActiveDirectoryConfigurationArgs']]:
        return pulumi.get(self, "self_managed_active_directory_configuration")

    @self_managed_active_directory_configuration.setter
    def self_managed_active_directory_configuration(self, value: Optional[pulumi.Input['FileSystemSelfManagedActiveDirectoryConfigurationArgs']]):
        pulumi.set(self, "self_managed_active_directory_configuration", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class SnapshotTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class StorageVirtualMachineActiveDirectoryConfigurationArgs:
    def __init__(__self__, *,
                 net_bios_name: Optional[pulumi.Input[str]] = None,
                 self_managed_active_directory_configuration: Optional[pulumi.Input['StorageVirtualMachineSelfManagedActiveDirectoryConfigurationArgs']] = None):
        if net_bios_name is not None:
            pulumi.set(__self__, "net_bios_name", net_bios_name)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)

    @property
    @pulumi.getter(name="netBiosName")
    def net_bios_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "net_bios_name")

    @net_bios_name.setter
    def net_bios_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_bios_name", value)

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional[pulumi.Input['StorageVirtualMachineSelfManagedActiveDirectoryConfigurationArgs']]:
        return pulumi.get(self, "self_managed_active_directory_configuration")

    @self_managed_active_directory_configuration.setter
    def self_managed_active_directory_configuration(self, value: Optional[pulumi.Input['StorageVirtualMachineSelfManagedActiveDirectoryConfigurationArgs']]):
        pulumi.set(self, "self_managed_active_directory_configuration", value)


@pulumi.input_type
class StorageVirtualMachineSelfManagedActiveDirectoryConfigurationArgs:
    def __init__(__self__, *,
                 dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 file_system_administrators_group: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_system_administrators_group")

    @file_system_administrators_group.setter
    def file_system_administrators_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_administrators_group", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class StorageVirtualMachineTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VolumeClientConfigurationsArgs:
    def __init__(__self__, *,
                 clients: pulumi.Input[str],
                 options: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> pulumi.Input[str]:
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: pulumi.Input[str]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter
    def options(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class VolumeNfsExportsArgs:
    def __init__(__self__, *,
                 client_configurations: pulumi.Input[Sequence[pulumi.Input['VolumeClientConfigurationsArgs']]]):
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeClientConfigurationsArgs']]]:
        return pulumi.get(self, "client_configurations")

    @client_configurations.setter
    def client_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeClientConfigurationsArgs']]]):
        pulumi.set(self, "client_configurations", value)


@pulumi.input_type
class VolumeOntapConfigurationArgs:
    def __init__(__self__, *,
                 size_in_megabytes: pulumi.Input[str],
                 storage_virtual_machine_id: pulumi.Input[str],
                 copy_tags_to_backups: Optional[pulumi.Input[str]] = None,
                 junction_path: Optional[pulumi.Input[str]] = None,
                 ontap_volume_type: Optional[pulumi.Input[str]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 snapshot_policy: Optional[pulumi.Input[str]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[str]] = None,
                 tiering_policy: Optional[pulumi.Input['VolumeTieringPolicyArgs']] = None):
        pulumi.set(__self__, "size_in_megabytes", size_in_megabytes)
        pulumi.set(__self__, "storage_virtual_machine_id", storage_virtual_machine_id)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if junction_path is not None:
            pulumi.set(__self__, "junction_path", junction_path)
        if ontap_volume_type is not None:
            pulumi.set(__self__, "ontap_volume_type", ontap_volume_type)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if snapshot_policy is not None:
            pulumi.set(__self__, "snapshot_policy", snapshot_policy)
        if storage_efficiency_enabled is not None:
            pulumi.set(__self__, "storage_efficiency_enabled", storage_efficiency_enabled)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)

    @property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> pulumi.Input[str]:
        return pulumi.get(self, "size_in_megabytes")

    @size_in_megabytes.setter
    def size_in_megabytes(self, value: pulumi.Input[str]):
        pulumi.set(self, "size_in_megabytes", value)

    @property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "storage_virtual_machine_id")

    @storage_virtual_machine_id.setter
    def storage_virtual_machine_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_virtual_machine_id", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "junction_path")

    @junction_path.setter
    def junction_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "junction_path", value)

    @property
    @pulumi.getter(name="ontapVolumeType")
    def ontap_volume_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ontap_volume_type")

    @ontap_volume_type.setter
    def ontap_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ontap_volume_type", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter(name="snapshotPolicy")
    def snapshot_policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "snapshot_policy")

    @snapshot_policy.setter
    def snapshot_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_policy", value)

    @property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "storage_efficiency_enabled")

    @storage_efficiency_enabled.setter
    def storage_efficiency_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_efficiency_enabled", value)

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['VolumeTieringPolicyArgs']]:
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['VolumeTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)


@pulumi.input_type
class VolumeOpenZFSConfigurationArgs:
    def __init__(__self__, *,
                 parent_volume_id: pulumi.Input[str],
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeNfsExportsArgs']]]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 origin_snapshot: Optional[pulumi.Input['VolumeOriginSnapshotArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 record_size_ki_b: Optional[pulumi.Input[int]] = None,
                 storage_capacity_quota_gi_b: Optional[pulumi.Input[int]] = None,
                 storage_capacity_reservation_gi_b: Optional[pulumi.Input[int]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeUserAndGroupQuotasArgs']]]] = None):
        pulumi.set(__self__, "parent_volume_id", parent_volume_id)
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if origin_snapshot is not None:
            pulumi.set(__self__, "origin_snapshot", origin_snapshot)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_ki_b is not None:
            pulumi.set(__self__, "record_size_ki_b", record_size_ki_b)
        if storage_capacity_quota_gi_b is not None:
            pulumi.set(__self__, "storage_capacity_quota_gi_b", storage_capacity_quota_gi_b)
        if storage_capacity_reservation_gi_b is not None:
            pulumi.set(__self__, "storage_capacity_reservation_gi_b", storage_capacity_reservation_gi_b)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "parent_volume_id")

    @parent_volume_id.setter
    def parent_volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent_volume_id", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeNfsExportsArgs']]]]:
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeNfsExportsArgs']]]]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> Optional[pulumi.Input['VolumeOriginSnapshotArgs']]:
        return pulumi.get(self, "origin_snapshot")

    @origin_snapshot.setter
    def origin_snapshot(self, value: Optional[pulumi.Input['VolumeOriginSnapshotArgs']]):
        pulumi.set(self, "origin_snapshot", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recordSizeKiB")
    def record_size_ki_b(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "record_size_ki_b")

    @record_size_ki_b.setter
    def record_size_ki_b(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_size_ki_b", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGiB")
    def storage_capacity_quota_gi_b(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "storage_capacity_quota_gi_b")

    @storage_capacity_quota_gi_b.setter
    def storage_capacity_quota_gi_b(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity_quota_gi_b", value)

    @property
    @pulumi.getter(name="storageCapacityReservationGiB")
    def storage_capacity_reservation_gi_b(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "storage_capacity_reservation_gi_b")

    @storage_capacity_reservation_gi_b.setter
    def storage_capacity_reservation_gi_b(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity_reservation_gi_b", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeUserAndGroupQuotasArgs']]]]:
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeUserAndGroupQuotasArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)


@pulumi.input_type
class VolumeOriginSnapshotArgs:
    def __init__(__self__, *,
                 copy_strategy: pulumi.Input[str],
                 snapshot_arn: pulumi.Input[str]):
        pulumi.set(__self__, "copy_strategy", copy_strategy)
        pulumi.set(__self__, "snapshot_arn", snapshot_arn)

    @property
    @pulumi.getter(name="copyStrategy")
    def copy_strategy(self) -> pulumi.Input[str]:
        return pulumi.get(self, "copy_strategy")

    @copy_strategy.setter
    def copy_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "copy_strategy", value)

    @property
    @pulumi.getter(name="snapshotARN")
    def snapshot_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "snapshot_arn")

    @snapshot_arn.setter
    def snapshot_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "snapshot_arn", value)


@pulumi.input_type
class VolumeTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VolumeTieringPolicyArgs:
    def __init__(__self__, *,
                 cooling_period: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        if cooling_period is not None:
            pulumi.set(__self__, "cooling_period", cooling_period)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coolingPeriod")
    def cooling_period(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cooling_period")

    @cooling_period.setter
    def cooling_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cooling_period", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VolumeUserAndGroupQuotasArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[int],
                 storage_capacity_quota_gi_b: pulumi.Input[int],
                 type: pulumi.Input[str]):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gi_b", storage_capacity_quota_gi_b)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[int]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGiB")
    def storage_capacity_quota_gi_b(self) -> pulumi.Input[int]:
        return pulumi.get(self, "storage_capacity_quota_gi_b")

    @storage_capacity_quota_gi_b.setter
    def storage_capacity_quota_gi_b(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_capacity_quota_gi_b", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


